/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.impl.number;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.python27.icu.impl.number.Exportable;
import org.python27.icu.impl.number.FormatQuantity;
import org.python27.icu.impl.number.Modifier;
import org.python27.icu.impl.number.ModifierHolder;
import org.python27.icu.impl.number.NumberStringBuilder;
import org.python27.icu.impl.number.Properties;
import org.python27.icu.impl.number.Rounder;
import org.python27.icu.text.PluralRules;

public abstract class Format {
    protected static final ThreadLocal<NumberStringBuilder> threadLocalStringBuilder = new ThreadLocal<NumberStringBuilder>(){

        @Override
        protected NumberStringBuilder initialValue() {
            return new NumberStringBuilder();
        }
    };
    protected static final ThreadLocal<ModifierHolder> threadLocalModifierHolder = new ThreadLocal<ModifierHolder>(){

        @Override
        protected ModifierHolder initialValue() {
            return new ModifierHolder();
        }
    };

    public String format(FormatQuantity ... inputs) {
        ArrayDeque<FormatQuantity> inputDeque = new ArrayDeque<FormatQuantity>();
        inputDeque.addAll(Arrays.asList(inputs));
        ModifierHolder modDeque = threadLocalModifierHolder.get().clear();
        NumberStringBuilder sb = threadLocalStringBuilder.get().clear();
        int length = this.process(inputDeque, modDeque, sb, 0);
        modDeque.applyAll(sb, 0, length);
        return sb.toString();
    }

    public abstract int process(Deque<FormatQuantity> var1, ModifierHolder var2, NumberStringBuilder var3, int var4);

    public static interface AfterFormat
    extends Exportable {
        public int after(ModifierHolder var1, NumberStringBuilder var2, int var3, int var4);
    }

    public static interface TargetFormat
    extends Exportable {
        public int target(FormatQuantity var1, NumberStringBuilder var2, int var3);
    }

    public static abstract class BeforeFormat
    implements Exportable {
        protected abstract void before(FormatQuantity var1, ModifierHolder var2);

        public void before(FormatQuantity input, ModifierHolder mods, PluralRules rules) {
            this.before(input, mods);
        }
    }

    public static class PositiveNegativeRounderTargetFormat
    extends SingularFormat {
        private final Modifier.PositiveNegativeModifier positiveNegative;
        private final Rounder rounder;
        private final TargetFormat target;

        public PositiveNegativeRounderTargetFormat(Modifier.PositiveNegativeModifier positiveNegative, Rounder rounder, TargetFormat target) {
            this.positiveNegative = positiveNegative;
            this.rounder = rounder;
            this.target = target;
        }

        @Override
        public String format(FormatQuantity input) {
            NumberStringBuilder sb = ((NumberStringBuilder)threadLocalStringBuilder.get()).clear();
            this.process(input, null, sb, 0);
            return sb.toString();
        }

        @Override
        public int process(FormatQuantity input, ModifierHolder mods, NumberStringBuilder string2, int startIndex) {
            Modifier mod2 = null;
            this.rounder.apply(input);
            if (!input.isNaN() && this.positiveNegative != null) {
                mod2 = this.positiveNegative.getModifier(input.isNegative());
            }
            int length = this.target.target(input, string2, startIndex);
            if (mod2 != null) {
                length += mod2.apply(string2, 0, length);
            }
            return length;
        }

        @Override
        public void export(Properties properties) {
            this.rounder.export(properties);
            this.positiveNegative.export(properties);
            this.target.export(properties);
        }
    }

    public static class BeforeTargetAfterFormat
    extends SingularFormat {
        private BeforeFormat before1 = null;
        private BeforeFormat before2 = null;
        private BeforeFormat before3 = null;
        private TargetFormat target = null;
        private AfterFormat after1 = null;
        private AfterFormat after2 = null;
        private AfterFormat after3 = null;
        private final PluralRules rules;

        public BeforeTargetAfterFormat(PluralRules rules) {
            this.rules = rules;
        }

        public void addBeforeFormat(BeforeFormat before) {
            if (this.before1 == null) {
                this.before1 = before;
            } else if (this.before2 == null) {
                this.before2 = before;
            } else if (this.before3 == null) {
                this.before3 = before;
            } else {
                throw new IllegalArgumentException("Only three BeforeFormats are allowed at a time");
            }
        }

        public void setTargetFormat(TargetFormat target) {
            this.target = target;
        }

        public void addAfterFormat(AfterFormat after) {
            if (this.after1 == null) {
                this.after1 = after;
            } else if (this.after2 == null) {
                this.after2 = after;
            } else if (this.after3 == null) {
                this.after3 = after;
            } else {
                throw new IllegalArgumentException("Only three AfterFormats are allowed at a time");
            }
        }

        @Override
        public String format(FormatQuantity input) {
            ModifierHolder mods = ((ModifierHolder)threadLocalModifierHolder.get()).clear();
            NumberStringBuilder sb = ((NumberStringBuilder)threadLocalStringBuilder.get()).clear();
            int length = this.process(input, mods, sb, 0);
            mods.applyAll(sb, 0, length);
            return sb.toString();
        }

        @Override
        public int process(FormatQuantity input, ModifierHolder mods, NumberStringBuilder string2, int startIndex) {
            int length = 0;
            if (!input.isNaN()) {
                if (this.before1 != null) {
                    this.before1.before(input, mods, this.rules);
                }
                if (this.before2 != null) {
                    this.before2.before(input, mods, this.rules);
                }
                if (this.before3 != null) {
                    this.before3.before(input, mods, this.rules);
                }
            }
            length = this.target.target(input, string2, startIndex);
            length += mods.applyStrong(string2, startIndex, startIndex + length);
            if (this.after1 != null) {
                length += this.after1.after(mods, string2, startIndex, startIndex + length);
            }
            if (this.after2 != null) {
                length += this.after2.after(mods, string2, startIndex, startIndex + length);
            }
            if (this.after3 != null) {
                length += this.after3.after(mods, string2, startIndex, startIndex + length);
            }
            return length;
        }

        @Override
        public void export(Properties properties) {
            if (this.before1 != null) {
                this.before1.export(properties);
            }
            if (this.before2 != null) {
                this.before2.export(properties);
            }
            if (this.before3 != null) {
                this.before3.export(properties);
            }
            this.target.export(properties);
            if (this.after1 != null) {
                this.after1.export(properties);
            }
            if (this.after2 != null) {
                this.after2.export(properties);
            }
            if (this.after3 != null) {
                this.after3.export(properties);
            }
        }
    }

    public static abstract class SingularFormat
    extends Format
    implements Exportable {
        public String format(FormatQuantity input) {
            NumberStringBuilder sb = this.formatToStringBuilder(input);
            return sb.toString();
        }

        public void format(FormatQuantity input, StringBuffer output) {
            NumberStringBuilder sb = this.formatToStringBuilder(input);
            output.append(sb);
        }

        public String format(FormatQuantity input, FieldPosition fp) {
            NumberStringBuilder sb = this.formatToStringBuilder(input);
            sb.populateFieldPosition(fp, 0);
            return sb.toString();
        }

        public void format(FormatQuantity input, StringBuffer output, FieldPosition fp) {
            NumberStringBuilder sb = this.formatToStringBuilder(input);
            sb.populateFieldPosition(fp, output.length());
            output.append(sb);
        }

        public AttributedCharacterIterator formatToCharacterIterator(FormatQuantity input) {
            NumberStringBuilder sb = this.formatToStringBuilder(input);
            return sb.getIterator();
        }

        private NumberStringBuilder formatToStringBuilder(FormatQuantity input) {
            ModifierHolder modDeque = ((ModifierHolder)threadLocalModifierHolder.get()).clear();
            NumberStringBuilder sb = ((NumberStringBuilder)threadLocalStringBuilder.get()).clear();
            int length = this.process(input, modDeque, sb, 0);
            length += modDeque.applyAll(sb, 0, length);
            return sb;
        }

        @Override
        public int process(Deque<FormatQuantity> input, ModifierHolder mods, NumberStringBuilder string2, int startIndex) {
            return this.process(input.removeFirst(), mods, string2, startIndex);
        }

        public abstract int process(FormatQuantity var1, ModifierHolder var2, NumberStringBuilder var3, int var4);
    }
}

