/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.impl.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.python27.icu.impl.number.FormatQuantity;
import org.python27.icu.impl.number.FormatQuantityBCD;

public final class FormatQuantity2
extends FormatQuantityBCD {
    private long bcd;

    @Override
    public int maxRepresentableDigits() {
        return 16;
    }

    public FormatQuantity2(long input) {
        this.setToLong(input);
    }

    public FormatQuantity2(int input) {
        this.setToInt(input);
    }

    public FormatQuantity2(double input) {
        this.setToDouble(input);
    }

    public FormatQuantity2(BigInteger input) {
        this.setToBigInteger(input);
    }

    public FormatQuantity2(BigDecimal input) {
        this.setToBigDecimal(input);
    }

    public FormatQuantity2(FormatQuantity2 other) {
        this.copyFrom(other);
    }

    @Override
    protected byte getDigitPos(int position) {
        if (position < 0 || position >= 16) {
            return 0;
        }
        return (byte)(this.bcd >>> position * 4 & 0xFL);
    }

    @Override
    protected void setDigitPos(int position, byte value) {
        assert (position >= 0 && position < 16);
        int shift = position * 4;
        this.bcd = this.bcd & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << shift;
    }

    @Override
    protected void shiftLeft(int numDigits) {
        assert (this.precision + numDigits <= 16);
        this.bcd <<= numDigits * 4;
        this.scale -= numDigits;
        this.precision += numDigits;
    }

    @Override
    protected void shiftRight(int numDigits) {
        this.bcd >>>= numDigits * 4;
        this.scale += numDigits;
        this.precision -= numDigits;
    }

    @Override
    protected void setBcdToZero() {
        this.bcd = 0L;
        this.scale = 0;
        this.precision = 0;
        this.isApproximate = false;
        this.origDouble = 0.0;
        this.origDelta = 0;
    }

    @Override
    protected void readIntToBcd(int n) {
        assert (n != 0);
        long result2 = 0L;
        int i = 16;
        while (n != 0) {
            result2 = (result2 >>> 4) + ((long)n % 10L << 60);
            n /= 10;
            --i;
        }
        this.bcd = result2 >>> i * 4;
        this.scale = 0;
        this.precision = 16 - i;
    }

    @Override
    protected void readLongToBcd(long n) {
        assert (n != 0L);
        long result2 = 0L;
        int i = 16;
        while (n != 0L) {
            result2 = (result2 >>> 4) + (n % 10L << 60);
            n /= 10L;
            --i;
        }
        int adjustment = i > 0 ? i : 0;
        this.bcd = result2 >>> adjustment * 4;
        this.scale = i < 0 ? -i : 0;
        this.precision = 16 - i;
    }

    @Override
    protected void readBigIntegerToBcd(BigInteger n) {
        assert (n.signum() != 0);
        long result2 = 0L;
        int i = 16;
        while (n.signum() != 0) {
            BigInteger[] temp = n.divideAndRemainder(BigInteger.TEN);
            result2 = (result2 >>> 4) + (temp[1].longValue() << 60);
            n = temp[0];
            --i;
        }
        int adjustment = i > 0 ? i : 0;
        this.bcd = result2 >>> adjustment * 4;
        this.scale = i < 0 ? -i : 0;
    }

    @Override
    protected BigDecimal bcdToBigDecimal() {
        long tempLong = 0L;
        for (int shift = this.precision - 1; shift >= 0; --shift) {
            tempLong = tempLong * 10L + (long)this.getDigitPos(shift);
        }
        BigDecimal result2 = BigDecimal.valueOf(tempLong);
        result2 = result2.scaleByPowerOfTen(this.scale);
        if (this.isNegative()) {
            result2 = result2.negate();
        }
        return result2;
    }

    @Override
    protected void compact() {
        if (this.bcd == 0L) {
            this.scale = 0;
            this.precision = 0;
            return;
        }
        int delta = Long.numberOfTrailingZeros(this.bcd) / 4;
        this.bcd >>>= delta * 4;
        this.scale += delta;
        this.precision = 16 - Long.numberOfLeadingZeros(this.bcd) / 4;
    }

    @Override
    protected void copyBcdFrom(FormatQuantity _other) {
        FormatQuantity2 other = (FormatQuantity2)_other;
        this.bcd = other.bcd;
    }

    public String toString() {
        return String.format("<FormatQuantity2 %s:%d:%d:%s %016XE%d>", this.lOptPos > 1000 ? "max" : String.valueOf(this.lOptPos), this.lReqPos, this.rReqPos, this.rOptPos < -1000 ? "min" : String.valueOf(this.rOptPos), this.bcd, this.scale);
    }
}

