/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.impl.number.formatters;

import java.math.BigDecimal;
import org.python27.icu.impl.StandardPlural;
import org.python27.icu.impl.number.AffixPatternUtils;
import org.python27.icu.impl.number.PNAffixGenerator;
import org.python27.icu.impl.number.PatternString;
import org.python27.icu.impl.number.Properties;
import org.python27.icu.impl.number.Rounder;
import org.python27.icu.impl.number.formatters.PositiveNegativeAffixFormat;
import org.python27.icu.impl.number.formatters.RoundingFormat;
import org.python27.icu.impl.number.modifiers.GeneralPluralModifier;
import org.python27.icu.impl.number.rounders.IncrementRounder;
import org.python27.icu.impl.number.rounders.MagnitudeRounder;
import org.python27.icu.impl.number.rounders.SignificantDigitsRounder;
import org.python27.icu.text.CurrencyPluralInfo;
import org.python27.icu.text.DecimalFormatSymbols;
import org.python27.icu.util.Currency;

public class CurrencyFormat {
    private static final Currency DEFAULT_CURRENCY = Currency.getInstance("XXX");
    private static final ThreadLocal<Properties> threadLocalProperties = new ThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return new Properties();
        }
    };

    public static boolean useCurrency(IProperties properties) {
        return properties.getCurrency() != null || properties.getCurrencyPluralInfo() != null || properties.getCurrencyUsage() != null || AffixPatternUtils.hasCurrencySymbols(properties.getPositivePrefixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getPositiveSuffixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getNegativePrefixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getNegativeSuffixPattern());
    }

    public static String getCurrencySymbol(DecimalFormatSymbols symbols2, ICurrencyProperties properties) {
        CurrencyStyle style = properties.getCurrencyStyle();
        if (style == CurrencyStyle.ISO_CODE) {
            return CurrencyFormat.getCurrencyIsoCode(symbols2, properties);
        }
        Currency currency = properties.getCurrency();
        if (currency == null) {
            return symbols2.getCurrencySymbol();
        }
        if (currency.equals(symbols2.getCurrency())) {
            return symbols2.getCurrencySymbol();
        }
        return currency.getName(symbols2.getULocale(), 0, null);
    }

    public static String getCurrencyIsoCode(DecimalFormatSymbols symbols2, ICurrencyProperties properties) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            return symbols2.getInternationalCurrencySymbol();
        }
        if (currency.equals(symbols2.getCurrency())) {
            return symbols2.getInternationalCurrencySymbol();
        }
        return currency.getCurrencyCode();
    }

    public static String getCurrencyLongName(DecimalFormatSymbols symbols2, ICurrencyProperties properties, StandardPlural plural) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            currency = symbols2.getCurrency();
        }
        if (currency == null) {
            return CurrencyFormat.getCurrencySymbol(symbols2, properties);
        }
        return currency.getName(symbols2.getULocale(), 2, plural.getKeyword(), null);
    }

    public static GeneralPluralModifier getCurrencyModifier(DecimalFormatSymbols symbols2, IProperties properties) {
        PNAffixGenerator pnag = PNAffixGenerator.getThreadLocalInstance();
        String sym = CurrencyFormat.getCurrencySymbol(symbols2, properties);
        String iso = CurrencyFormat.getCurrencyIsoCode(symbols2, properties);
        CurrencyPluralInfo info = properties.getCurrencyPluralInfo();
        GeneralPluralModifier mod2 = new GeneralPluralModifier();
        Properties temp = new Properties();
        for (StandardPlural plural : StandardPlural.VALUES) {
            PNAffixGenerator.Result result2;
            String longName = CurrencyFormat.getCurrencyLongName(symbols2, properties, plural);
            if (info == null) {
                result2 = pnag.getModifiers(symbols2, sym, iso, longName, properties);
            } else {
                String pluralPattern = info.getCurrencyPluralPattern(plural.getKeyword());
                PatternString.parseToExistingProperties(pluralPattern, temp, true);
                result2 = pnag.getModifiers(symbols2, sym, iso, longName, temp);
            }
            mod2.put(plural, result2.positive, result2.negative);
        }
        return mod2;
    }

    public static void populateCurrencyRounderProperties(Properties destination, DecimalFormatSymbols symbols2, IProperties properties) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            currency = symbols2.getCurrency();
        }
        if (currency == null) {
            currency = DEFAULT_CURRENCY;
        }
        Currency.CurrencyUsage _currencyUsage = properties.getCurrencyUsage();
        int _minFrac = properties.getMinimumFractionDigits();
        int _maxFrac = properties.getMaximumFractionDigits();
        Currency.CurrencyUsage effectiveCurrencyUsage = _currencyUsage != null ? _currencyUsage : Currency.CurrencyUsage.STANDARD;
        double incrementDouble = currency.getRoundingIncrement(effectiveCurrencyUsage);
        int fractionDigits = currency.getDefaultFractionDigits(effectiveCurrencyUsage);
        destination.setRoundingMode(properties.getRoundingMode());
        destination.setMinimumIntegerDigits(properties.getMinimumIntegerDigits());
        destination.setMaximumIntegerDigits(properties.getMaximumIntegerDigits());
        if (_currencyUsage == null && (_minFrac >= 0 || _maxFrac >= 0)) {
            if (_minFrac < 0) {
                destination.setMinimumFractionDigits(fractionDigits < _maxFrac ? fractionDigits : _maxFrac);
                destination.setMaximumFractionDigits(_maxFrac);
            } else if (_maxFrac < 0) {
                destination.setMinimumFractionDigits(_minFrac);
                destination.setMaximumFractionDigits(fractionDigits > _minFrac ? fractionDigits : _minFrac);
            } else {
                destination.setMinimumFractionDigits(_minFrac);
                destination.setMaximumFractionDigits(_maxFrac);
            }
        } else {
            destination.setMinimumFractionDigits(fractionDigits);
            destination.setMaximumFractionDigits(fractionDigits);
        }
        if (incrementDouble > 0.0) {
            BigDecimal _roundingIncrement = properties.getRoundingIncrement();
            BigDecimal incrementBigDecimal = _roundingIncrement != null ? _roundingIncrement : BigDecimal.valueOf(incrementDouble);
            destination.setRoundingIncrement(incrementBigDecimal);
        }
    }

    public static Rounder getCurrencyRounder(DecimalFormatSymbols symbols2, IProperties properties) {
        if (SignificantDigitsRounder.useSignificantDigits(properties)) {
            return SignificantDigitsRounder.getInstance(properties);
        }
        Properties cprops = threadLocalProperties.get().clear();
        CurrencyFormat.populateCurrencyRounderProperties(cprops, symbols2, properties);
        if (cprops.getRoundingIncrement() != null) {
            return IncrementRounder.getInstance(cprops);
        }
        return MagnitudeRounder.getInstance(cprops);
    }

    public static interface IProperties
    extends ICurrencyProperties,
    RoundingFormat.IProperties,
    PositiveNegativeAffixFormat.IProperties {
    }

    public static interface ICurrencyProperties {
        public static final Currency DEFAULT_CURRENCY = null;
        public static final CurrencyStyle DEFAULT_CURRENCY_STYLE = null;
        public static final Currency.CurrencyUsage DEFAULT_CURRENCY_USAGE = null;
        public static final CurrencyPluralInfo DEFAULT_CURRENCY_PLURAL_INFO = null;

        public Currency getCurrency();

        public IProperties setCurrency(Currency var1);

        public CurrencyStyle getCurrencyStyle();

        public IProperties setCurrencyStyle(CurrencyStyle var1);

        public Currency.CurrencyUsage getCurrencyUsage();

        public IProperties setCurrencyUsage(Currency.CurrencyUsage var1);

        @Deprecated
        public CurrencyPluralInfo getCurrencyPluralInfo();

        @Deprecated
        public IProperties setCurrencyPluralInfo(CurrencyPluralInfo var1);
    }

    public static enum CurrencyStyle {
        SYMBOL,
        ISO_CODE;

    }
}

