/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.text;

import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import org.python27.icu.text.MeasureFormat;
import org.python27.icu.text.NumberFormat;
import org.python27.icu.util.CurrencyAmount;
import org.python27.icu.util.Measure;
import org.python27.icu.util.ULocale;

class CurrencyFormat
extends MeasureFormat {
    static final long serialVersionUID = -931679363692504634L;
    private NumberFormat fmt;
    private final transient MeasureFormat mf;

    public CurrencyFormat(ULocale locale2) {
        this.setLocale(locale2, locale2);
        this.mf = MeasureFormat.getInstance(locale2, MeasureFormat.FormatWidth.WIDE);
        this.fmt = NumberFormat.getCurrencyInstance(locale2.toLocale());
    }

    @Override
    public Object clone() {
        CurrencyFormat result2 = (CurrencyFormat)super.clone();
        result2.fmt = (NumberFormat)this.fmt.clone();
        return result2;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof CurrencyAmount)) {
            throw new IllegalArgumentException("Invalid type: " + obj.getClass().getName());
        }
        CurrencyAmount currency = (CurrencyAmount)obj;
        this.fmt.setCurrency(currency.getCurrency());
        return this.fmt.format(currency.getNumber(), toAppendTo, pos);
    }

    @Override
    public CurrencyAmount parseObject(String source, ParsePosition pos) {
        return this.fmt.parseCurrency(source, pos);
    }

    @Override
    public StringBuilder formatMeasures(StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        return this.mf.formatMeasures(appendTo, fieldPosition, measures);
    }

    @Override
    public MeasureFormat.FormatWidth getWidth() {
        return this.mf.getWidth();
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.mf.getNumberFormat();
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.mf.toCurrencyProxy();
    }

    private Object readResolve() throws ObjectStreamException {
        return new CurrencyFormat(this.fmt.getLocale(ULocale.ACTUAL_LOCALE));
    }
}

