/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.python27.icu.impl.Assert;
import org.python27.icu.impl.CharTrie;
import org.python27.icu.impl.CharacterIteration;
import org.python27.icu.impl.ICUBinary;
import org.python27.icu.impl.ICUDebug;
import org.python27.icu.lang.UCharacter;
import org.python27.icu.text.BreakIterator;
import org.python27.icu.text.BurmeseBreakEngine;
import org.python27.icu.text.CjkBreakEngine;
import org.python27.icu.text.DictionaryBreakEngine;
import org.python27.icu.text.KhmerBreakEngine;
import org.python27.icu.text.LanguageBreakEngine;
import org.python27.icu.text.LaoBreakEngine;
import org.python27.icu.text.RBBIDataWrapper;
import org.python27.icu.text.RBBIRuleBuilder;
import org.python27.icu.text.ThaiBreakEngine;
import org.python27.icu.text.UnhandledBreakEngine;

public class RuleBasedBreakIterator
extends BreakIterator {
    private static final int START_STATE = 1;
    private static final int STOP_STATE = 0;
    private static final int RBBI_START = 0;
    private static final int RBBI_RUN = 1;
    private static final int RBBI_END = 2;
    private CharacterIterator fText = new StringCharacterIterator("");
    RBBIDataWrapper fRData;
    private int fLastRuleStatusIndex;
    private boolean fLastStatusIndexValid = true;
    private int fDictionaryCharCount = 0;
    private static final String RBBI_DEBUG_ARG = "rbbi";
    private static final boolean TRACE = ICUDebug.enabled("rbbi") && ICUDebug.value("rbbi").indexOf("trace") >= 0;
    private int fBreakType = 2;
    private static final UnhandledBreakEngine gUnhandledBreakEngine = new UnhandledBreakEngine();
    private static final List<LanguageBreakEngine> gAllBreakEngines = new ArrayList<LanguageBreakEngine>();
    private List<LanguageBreakEngine> fBreakEngines;
    private int[] fCachedBreakPositions;
    private int fPositionInCache;
    static final String fDebugEnv;
    private static final int kMaxLookaheads = 8;
    private LookAheadResults fLookAheadMatches = new LookAheadResults();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleBasedBreakIterator() {
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            this.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
        }
    }

    public static RuleBasedBreakIterator getInstanceFromCompiledRules(InputStream is) throws IOException {
        RuleBasedBreakIterator This = new RuleBasedBreakIterator();
        This.fRData = RBBIDataWrapper.get(ICUBinary.getByteBufferFromInputStreamAndCloseStream(is));
        return This;
    }

    @Deprecated
    public static RuleBasedBreakIterator getInstanceFromCompiledRules(ByteBuffer bytes) throws IOException {
        RuleBasedBreakIterator This = new RuleBasedBreakIterator();
        This.fRData = RBBIDataWrapper.get(bytes);
        return This;
    }

    public RuleBasedBreakIterator(String rules) {
        this();
        try {
            ByteArrayOutputStream ruleOS = new ByteArrayOutputStream();
            RuleBasedBreakIterator.compileRules(rules, ruleOS);
            this.fRData = RBBIDataWrapper.get(ByteBuffer.wrap(ruleOS.toByteArray()));
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("RuleBasedBreakIterator rule compilation internal error: " + e.getMessage());
            throw rte;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        RuleBasedBreakIterator result2 = (RuleBasedBreakIterator)super.clone();
        if (this.fText != null) {
            result2.fText = (CharacterIterator)this.fText.clone();
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            result2.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
        }
        result2.fLookAheadMatches = new LookAheadResults();
        if (this.fCachedBreakPositions != null) {
            result2.fCachedBreakPositions = (int[])this.fCachedBreakPositions.clone();
        }
        return result2;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        try {
            RuleBasedBreakIterator other = (RuleBasedBreakIterator)that;
            if (this.fRData != other.fRData && (this.fRData == null || other.fRData == null)) {
                return false;
            }
            if (this.fRData != null && other.fRData != null && !this.fRData.fRuleSource.equals(other.fRData.fRuleSource)) {
                return false;
            }
            if (this.fText == null && other.fText == null) {
                return true;
            }
            if (this.fText == null || other.fText == null) {
                return false;
            }
            return this.fText.equals(other.fText);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        String retStr = "";
        if (this.fRData != null) {
            retStr = this.fRData.fRuleSource;
        }
        return retStr;
    }

    public int hashCode() {
        return this.fRData.fRuleSource.hashCode();
    }

    private void reset() {
        this.fCachedBreakPositions = null;
        this.fDictionaryCharCount = 0;
        this.fPositionInCache = 0;
    }

    @Deprecated
    public void dump(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        this.fRData.dump(out);
    }

    public static void compileRules(String rules, OutputStream ruleBinary) throws IOException {
        RBBIRuleBuilder.compileRules(rules, ruleBinary);
    }

    @Override
    public int first() {
        this.fCachedBreakPositions = null;
        this.fDictionaryCharCount = 0;
        this.fPositionInCache = 0;
        this.fLastRuleStatusIndex = 0;
        this.fLastStatusIndexValid = true;
        if (this.fText == null) {
            return -1;
        }
        this.fText.first();
        return this.fText.getIndex();
    }

    @Override
    public int last() {
        this.fCachedBreakPositions = null;
        this.fDictionaryCharCount = 0;
        this.fPositionInCache = 0;
        if (this.fText == null) {
            this.fLastRuleStatusIndex = 0;
            this.fLastStatusIndexValid = true;
            return -1;
        }
        this.fLastStatusIndexValid = false;
        int pos = this.fText.getEndIndex();
        this.fText.setIndex(pos);
        return pos;
    }

    @Override
    public int next(int n) {
        int result2 = this.current();
        while (n > 0) {
            result2 = this.next();
            --n;
        }
        while (n < 0) {
            result2 = this.previous();
            ++n;
        }
        return result2;
    }

    @Override
    public int next() {
        if (this.fCachedBreakPositions != null) {
            if (this.fPositionInCache < this.fCachedBreakPositions.length - 1) {
                ++this.fPositionInCache;
                int pos = this.fCachedBreakPositions[this.fPositionInCache];
                this.fText.setIndex(pos);
                return pos;
            }
            this.reset();
        }
        int startPos = this.current();
        this.fDictionaryCharCount = 0;
        int result2 = this.handleNext(this.fRData.fFTable);
        if (this.fDictionaryCharCount > 0) {
            result2 = this.checkDictionary(startPos, result2, false);
        }
        return result2;
    }

    private int checkDictionary(int startPos, int endPos, boolean reverse) {
        this.reset();
        if (endPos - startPos <= 1) {
            return reverse ? startPos : endPos;
        }
        this.fText.setIndex(reverse ? endPos : startPos);
        if (reverse) {
            CharacterIteration.previous32(this.fText);
        }
        int rangeStart = startPos;
        int rangeEnd = endPos;
        DictionaryBreakEngine.DequeI breaks = new DictionaryBreakEngine.DequeI();
        int foundBreakCount = 0;
        int c = CharacterIteration.current32(this.fText);
        short category = (short)this.fRData.fTrie.getCodePointValue(c);
        if ((category & 0x4000) != 0) {
            if (reverse) {
                do {
                    CharacterIteration.next32(this.fText);
                    c = CharacterIteration.current32(this.fText);
                    category = (short)this.fRData.fTrie.getCodePointValue(c);
                } while (c != Integer.MAX_VALUE && (category & 0x4000) != 0);
                rangeEnd = this.fText.getIndex();
                c = c == Integer.MAX_VALUE ? CharacterIteration.previous32(this.fText) : CharacterIteration.previous32(this.fText);
            } else {
                do {
                    c = CharacterIteration.previous32(this.fText);
                    category = (short)this.fRData.fTrie.getCodePointValue(c);
                } while (c != Integer.MAX_VALUE && (category & 0x4000) != 0);
                if (c == Integer.MAX_VALUE) {
                    c = CharacterIteration.current32(this.fText);
                } else {
                    CharacterIteration.next32(this.fText);
                    c = CharacterIteration.current32(this.fText);
                }
                rangeStart = this.fText.getIndex();
            }
            category = (short)this.fRData.fTrie.getCodePointValue(c);
        }
        if (reverse) {
            this.fText.setIndex(rangeStart);
            c = CharacterIteration.current32(this.fText);
            category = (short)this.fRData.fTrie.getCodePointValue(c);
        }
        LanguageBreakEngine lbe = null;
        while (true) {
            int current;
            if ((current = this.fText.getIndex()) < rangeEnd && (category & 0x4000) == 0) {
                CharacterIteration.next32(this.fText);
                c = CharacterIteration.current32(this.fText);
                category = (short)this.fRData.fTrie.getCodePointValue(c);
                continue;
            }
            if (current >= rangeEnd) break;
            lbe = this.getLanguageBreakEngine(c);
            if (lbe != null) {
                int startingIdx = this.fText.getIndex();
                foundBreakCount += lbe.findBreaks(this.fText, rangeStart, rangeEnd, false, this.fBreakType, breaks);
                assert (this.fText.getIndex() > startingIdx);
            }
            c = CharacterIteration.current32(this.fText);
            category = (short)this.fRData.fTrie.getCodePointValue(c);
        }
        if (foundBreakCount > 0) {
            if (foundBreakCount != breaks.size()) {
                System.out.println("oops, foundBreakCount != breaks.size().  LBE = " + lbe.getClass());
            }
            assert (foundBreakCount == breaks.size());
            if (startPos < breaks.peekLast()) {
                breaks.offer(startPos);
            }
            if (endPos > breaks.peek()) {
                breaks.push(endPos);
            }
            this.fCachedBreakPositions = new int[breaks.size()];
            int i = 0;
            while (breaks.size() > 0) {
                this.fCachedBreakPositions[i++] = breaks.pollLast();
            }
            if (reverse) {
                return this.preceding(endPos);
            }
            return this.following(startPos);
        }
        this.fText.setIndex(reverse ? startPos : endPos);
        return reverse ? startPos : endPos;
    }

    @Override
    public int previous() {
        CharacterIterator text2 = this.getText();
        this.fLastStatusIndexValid = false;
        if (this.fCachedBreakPositions != null) {
            if (this.fPositionInCache > 0) {
                --this.fPositionInCache;
                if (this.fPositionInCache <= 0) {
                    this.fLastStatusIndexValid = false;
                }
                int pos = this.fCachedBreakPositions[this.fPositionInCache];
                text2.setIndex(pos);
                return pos;
            }
            this.reset();
        }
        int startPos = this.current();
        if (this.fText == null || startPos == this.fText.getBeginIndex()) {
            this.fLastRuleStatusIndex = 0;
            this.fLastStatusIndexValid = true;
            return -1;
        }
        if (this.fRData.fSRTable != null || this.fRData.fSFTable != null) {
            int result2 = this.handlePrevious(this.fRData.fRTable);
            if (this.fDictionaryCharCount > 0) {
                result2 = this.checkDictionary(result2, startPos, true);
            }
            return result2;
        }
        int start = this.current();
        CharacterIteration.previous32(this.fText);
        int lastResult = this.handlePrevious(this.fRData.fRTable);
        if (lastResult == -1) {
            lastResult = this.fText.getBeginIndex();
            this.fText.setIndex(lastResult);
        }
        int result3 = lastResult;
        int lastTag = 0;
        boolean breakTagValid = false;
        while ((result3 = this.next()) != -1 && result3 < start) {
            lastResult = result3;
            lastTag = this.fLastRuleStatusIndex;
            breakTagValid = true;
        }
        this.fText.setIndex(lastResult);
        this.fLastRuleStatusIndex = lastTag;
        this.fLastStatusIndexValid = breakTagValid;
        return lastResult;
    }

    @Override
    public int following(int offset) {
        CharacterIterator text2 = this.getText();
        if (this.fCachedBreakPositions == null || offset < this.fCachedBreakPositions[0] || offset >= this.fCachedBreakPositions[this.fCachedBreakPositions.length - 1]) {
            this.fCachedBreakPositions = null;
            return this.rulesFollowing(offset);
        }
        this.fPositionInCache = 0;
        while (this.fPositionInCache < this.fCachedBreakPositions.length && offset >= this.fCachedBreakPositions[this.fPositionInCache]) {
            ++this.fPositionInCache;
        }
        text2.setIndex(this.fCachedBreakPositions[this.fPositionInCache]);
        return text2.getIndex();
    }

    private int rulesFollowing(int offset) {
        this.fLastRuleStatusIndex = 0;
        this.fLastStatusIndexValid = true;
        if (this.fText == null || offset >= this.fText.getEndIndex()) {
            this.last();
            return this.next();
        }
        if (offset < this.fText.getBeginIndex()) {
            return this.first();
        }
        int result2 = 0;
        if (this.fRData.fSRTable != null) {
            this.fText.setIndex(offset);
            CharacterIteration.next32(this.fText);
            this.handlePrevious(this.fRData.fSRTable);
            result2 = this.next();
            while (result2 <= offset) {
                result2 = this.next();
            }
            return result2;
        }
        if (this.fRData.fSFTable != null) {
            this.fText.setIndex(offset);
            CharacterIteration.previous32(this.fText);
            this.handleNext(this.fRData.fSFTable);
            int oldresult = this.previous();
            while (oldresult > offset) {
                result2 = this.previous();
                if (result2 <= offset) {
                    return oldresult;
                }
                oldresult = result2;
            }
            result2 = this.next();
            if (result2 <= offset) {
                return this.next();
            }
            return result2;
        }
        this.fText.setIndex(offset);
        if (offset == this.fText.getBeginIndex()) {
            return this.next();
        }
        result2 = this.previous();
        while (result2 != -1 && result2 <= offset) {
            result2 = this.next();
        }
        return result2;
    }

    @Override
    public int preceding(int offset) {
        CharacterIterator text2 = this.getText();
        if (this.fCachedBreakPositions == null || offset <= this.fCachedBreakPositions[0] || offset > this.fCachedBreakPositions[this.fCachedBreakPositions.length - 1]) {
            this.fCachedBreakPositions = null;
            return this.rulesPreceding(offset);
        }
        this.fPositionInCache = 0;
        while (this.fPositionInCache < this.fCachedBreakPositions.length && offset > this.fCachedBreakPositions[this.fPositionInCache]) {
            ++this.fPositionInCache;
        }
        --this.fPositionInCache;
        text2.setIndex(this.fCachedBreakPositions[this.fPositionInCache]);
        return text2.getIndex();
    }

    private int rulesPreceding(int offset) {
        if (this.fText == null || offset > this.fText.getEndIndex()) {
            return this.last();
        }
        if (offset < this.fText.getBeginIndex()) {
            return this.first();
        }
        if (this.fRData.fSFTable != null) {
            this.fText.setIndex(offset);
            CharacterIteration.previous32(this.fText);
            this.handleNext(this.fRData.fSFTable);
            int result2 = this.previous();
            while (result2 >= offset) {
                result2 = this.previous();
            }
            return result2;
        }
        if (this.fRData.fSRTable != null) {
            int result3;
            this.fText.setIndex(offset);
            CharacterIteration.next32(this.fText);
            this.handlePrevious(this.fRData.fSRTable);
            int oldresult = this.next();
            while (oldresult < offset) {
                result3 = this.next();
                if (result3 >= offset) {
                    return oldresult;
                }
                oldresult = result3;
            }
            result3 = this.previous();
            if (result3 >= offset) {
                return this.previous();
            }
            return result3;
        }
        this.fText.setIndex(offset);
        return this.previous();
    }

    protected static final void checkOffset(int offset, CharacterIterator text2) {
        if (offset < text2.getBeginIndex() || offset > text2.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    @Override
    public boolean isBoundary(int offset) {
        RuleBasedBreakIterator.checkOffset(offset, this.fText);
        if (offset == this.fText.getBeginIndex()) {
            this.first();
            return true;
        }
        if (offset == this.fText.getEndIndex()) {
            this.last();
            return true;
        }
        this.fText.setIndex(offset);
        CharacterIteration.previous32(this.fText);
        int pos = this.fText.getIndex();
        boolean result2 = this.following(pos) == offset;
        return result2;
    }

    @Override
    public int current() {
        return this.fText != null ? this.fText.getIndex() : -1;
    }

    private void makeRuleStatusValid() {
        if (!this.fLastStatusIndexValid) {
            int curr = this.current();
            if (curr == -1 || curr == this.fText.getBeginIndex()) {
                this.fLastRuleStatusIndex = 0;
                this.fLastStatusIndexValid = true;
            } else {
                int pa = this.fText.getIndex();
                this.first();
                int pb = this.current();
                while (this.fText.getIndex() < pa) {
                    pb = this.next();
                }
                Assert.assrt(pa == pb);
            }
            Assert.assrt(this.fLastStatusIndexValid);
            Assert.assrt(this.fLastRuleStatusIndex >= 0 && this.fLastRuleStatusIndex < this.fRData.fStatusTable.length);
        }
    }

    @Override
    public int getRuleStatus() {
        this.makeRuleStatusValid();
        int idx = this.fLastRuleStatusIndex + this.fRData.fStatusTable[this.fLastRuleStatusIndex];
        int tagVal = this.fRData.fStatusTable[idx];
        return tagVal;
    }

    @Override
    public int getRuleStatusVec(int[] fillInArray) {
        this.makeRuleStatusValid();
        int numStatusVals = this.fRData.fStatusTable[this.fLastRuleStatusIndex];
        if (fillInArray != null) {
            int numToCopy = Math.min(numStatusVals, fillInArray.length);
            for (int i = 0; i < numToCopy; ++i) {
                fillInArray[i] = this.fRData.fStatusTable[this.fLastRuleStatusIndex + i + 1];
            }
        }
        return numStatusVals;
    }

    @Override
    public CharacterIterator getText() {
        return this.fText;
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.fText = newText;
        this.first();
    }

    void setBreakType(int type) {
        this.fBreakType = type;
    }

    int getBreakType() {
        return this.fBreakType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanguageBreakEngine getLanguageBreakEngine(int c) {
        for (LanguageBreakEngine languageBreakEngine : this.fBreakEngines) {
            if (!languageBreakEngine.handles(c, this.fBreakType)) continue;
            return languageBreakEngine;
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            LanguageBreakEngine eng;
            int n;
            for (LanguageBreakEngine candidate : gAllBreakEngines) {
                if (!candidate.handles(c, this.fBreakType)) continue;
                this.fBreakEngines.add(candidate);
                return candidate;
            }
            int n2 = UCharacter.getIntPropertyValue(c, 4106);
            if (n2 == 22 || n2 == 20) {
                n = 17;
            }
            try {
                switch (n) {
                    case 38: {
                        eng = new ThaiBreakEngine();
                        break;
                    }
                    case 24: {
                        eng = new LaoBreakEngine();
                        break;
                    }
                    case 28: {
                        eng = new BurmeseBreakEngine();
                        break;
                    }
                    case 23: {
                        eng = new KhmerBreakEngine();
                        break;
                    }
                    case 17: {
                        if (this.getBreakType() == 1) {
                            eng = new CjkBreakEngine(false);
                            break;
                        }
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                    case 18: {
                        if (this.getBreakType() == 1) {
                            eng = new CjkBreakEngine(true);
                            break;
                        }
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                    default: {
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                }
            }
            catch (IOException e) {
                eng = null;
            }
            if (eng != null && eng != gUnhandledBreakEngine) {
                gAllBreakEngines.add(eng);
                this.fBreakEngines.add(eng);
            }
            return eng;
        }
    }

    private int handleNext(short[] stateTable) {
        int initialPosition;
        if (TRACE) {
            System.out.println("Handle Next   pos      char  state category");
        }
        this.fLastStatusIndexValid = true;
        this.fLastRuleStatusIndex = 0;
        CharacterIterator text2 = this.fText;
        CharTrie trie = this.fRData.fTrie;
        int c = text2.current();
        if (c >= 55296 && (c = CharacterIteration.nextTrail32(text2, c)) == Integer.MAX_VALUE) {
            return -1;
        }
        int result2 = initialPosition = text2.getIndex();
        int state = 1;
        int row = this.fRData.getRowIndex(state);
        int category = 3;
        int flagsState = this.fRData.getStateTableFlags(stateTable);
        int mode = 1;
        if ((flagsState & 2) != 0) {
            category = 2;
            mode = 0;
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(text2.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
            }
        }
        this.fLookAheadMatches.reset();
        while (state != 0) {
            int lookaheadResult;
            short completedRule;
            if (c == Integer.MAX_VALUE) {
                if (mode == 2) break;
                mode = 2;
                category = 1;
            } else if (mode == 1) {
                category = (short)trie.getCodePointValue(c);
                if ((category & 0x4000) != 0) {
                    ++this.fDictionaryCharCount;
                    category = (short)(category & 0xFFFFBFFF);
                }
                if (TRACE) {
                    System.out.print("            " + RBBIDataWrapper.intToString(text2.getIndex(), 5));
                    System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                    System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
                }
                if ((c = (int)text2.next()) >= 55296) {
                    c = CharacterIteration.nextTrail32(text2, c);
                }
            } else {
                mode = 1;
            }
            state = stateTable[row + 4 + category];
            row = this.fRData.getRowIndex(state);
            if (stateTable[row + 0] == -1) {
                result2 = text2.getIndex();
                if (c >= 65536 && c <= 0x10FFFF) {
                    --result2;
                }
                this.fLastRuleStatusIndex = stateTable[row + 2];
            }
            if ((completedRule = stateTable[row + 0]) > 0 && (lookaheadResult = this.fLookAheadMatches.getPosition(completedRule)) >= 0) {
                this.fLastRuleStatusIndex = stateTable[row + 2];
                text2.setIndex(lookaheadResult);
                return lookaheadResult;
            }
            short rule = stateTable[row + 1];
            if (rule == 0) continue;
            int pos = text2.getIndex();
            if (c >= 65536 && c <= 0x10FFFF) {
                --pos;
            }
            this.fLookAheadMatches.setPosition(rule, pos);
        }
        if (result2 == initialPosition) {
            if (TRACE) {
                System.out.println("Iterator did not move. Advancing by 1.");
            }
            text2.setIndex(initialPosition);
            CharacterIteration.next32(text2);
            result2 = text2.getIndex();
        } else {
            text2.setIndex(result2);
        }
        if (TRACE) {
            System.out.println("result = " + result2);
        }
        return result2;
    }

    private int handlePrevious(short[] stateTable) {
        if (this.fText == null || stateTable == null) {
            return 0;
        }
        int category = 0;
        int result2 = 0;
        int initialPosition = 0;
        this.fLookAheadMatches.reset();
        this.fLastStatusIndexValid = false;
        this.fLastRuleStatusIndex = 0;
        result2 = initialPosition = this.fText.getIndex();
        int c = CharacterIteration.previous32(this.fText);
        int state = 1;
        int row = this.fRData.getRowIndex(state);
        category = 3;
        int mode = 1;
        if ((this.fRData.getStateTableFlags(stateTable) & 2) != 0) {
            category = 2;
            mode = 0;
        }
        if (TRACE) {
            System.out.println("Handle Prev   pos   char  state category ");
        }
        while (true) {
            int lookaheadResult;
            short completedRule;
            if (c == Integer.MAX_VALUE) {
                if (mode == 2 || this.fRData.fHeader.fVersion == 1) {
                    if (result2 != initialPosition) break;
                    this.fText.setIndex(initialPosition);
                    CharacterIteration.previous32(this.fText);
                    break;
                }
                mode = 2;
                category = 1;
            }
            if (mode == 1 && ((category = (int)((short)this.fRData.fTrie.getCodePointValue(c))) & 0x4000) != 0) {
                ++this.fDictionaryCharCount;
                category &= 0xFFFFBFFF;
            }
            if (TRACE) {
                System.out.print("             " + this.fText.getIndex() + "   ");
                if (32 <= c && c < 127) {
                    System.out.print("  " + c + "  ");
                } else {
                    System.out.print(" " + Integer.toHexString(c) + " ");
                }
                System.out.println(" " + state + "  " + category + " ");
            }
            if (stateTable[(row = this.fRData.getRowIndex(state = stateTable[row + 4 + category])) + 0] == -1) {
                result2 = this.fText.getIndex();
            }
            if ((completedRule = stateTable[row + 0]) > 0 && (lookaheadResult = this.fLookAheadMatches.getPosition(completedRule)) >= 0) {
                result2 = lookaheadResult;
                break;
            }
            short rule = stateTable[row + 1];
            if (rule != 0) {
                int pos = this.fText.getIndex();
                this.fLookAheadMatches.setPosition(rule, pos);
            }
            if (state == 0) break;
            if (mode == 1) {
                c = CharacterIteration.previous32(this.fText);
                continue;
            }
            if (mode != 0) continue;
            mode = 1;
        }
        if (result2 == initialPosition) {
            result2 = this.fText.setIndex(initialPosition);
            CharacterIteration.previous32(this.fText);
            result2 = this.fText.getIndex();
        }
        this.fText.setIndex(result2);
        if (TRACE) {
            System.out.println("Result = " + result2);
        }
        return result2;
    }

    static {
        gAllBreakEngines.add(gUnhandledBreakEngine);
        fDebugEnv = ICUDebug.enabled(RBBI_DEBUG_ARG) ? ICUDebug.value(RBBI_DEBUG_ARG) : null;
    }

    private static class LookAheadResults {
        int fUsedSlotLimit = 0;
        int[] fPositions = new int[8];
        int[] fKeys = new int[8];

        LookAheadResults() {
        }

        int getPosition(int key) {
            for (int i = 0; i < this.fUsedSlotLimit; ++i) {
                if (this.fKeys[i] != key) continue;
                return this.fPositions[i];
            }
            assert (false);
            return -1;
        }

        void setPosition(int key, int position) {
            int i;
            for (i = 0; i < this.fUsedSlotLimit; ++i) {
                if (this.fKeys[i] != key) continue;
                this.fPositions[i] = position;
                return;
            }
            if (i >= 8) {
                assert (false);
                i = 7;
            }
            this.fKeys[i] = key;
            this.fPositions[i] = position;
            assert (this.fUsedSlotLimit == i);
            this.fUsedSlotLimit = i + 1;
        }

        void reset() {
            this.fUsedSlotLimit = 0;
        }
    }
}

