/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.text;

import java.text.CharacterIterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.python27.icu.impl.CharacterIteration;
import org.python27.icu.lang.UCharacter;
import org.python27.icu.text.DictionaryBreakEngine;
import org.python27.icu.text.LanguageBreakEngine;
import org.python27.icu.text.UnicodeSet;

final class UnhandledBreakEngine
implements LanguageBreakEngine {
    final AtomicReferenceArray<UnicodeSet> fHandled = new AtomicReferenceArray(5);

    public UnhandledBreakEngine() {
        for (int i = 0; i < this.fHandled.length(); ++i) {
            this.fHandled.set(i, new UnicodeSet());
        }
    }

    @Override
    public boolean handles(int c, int breakType) {
        return breakType >= 0 && breakType < this.fHandled.length() && this.fHandled.get(breakType).contains(c);
    }

    @Override
    public int findBreaks(CharacterIterator text2, int startPos, int endPos, boolean reverse, int breakType, DictionaryBreakEngine.DequeI foundBreaks) {
        block4: {
            if (breakType < 0 || breakType >= this.fHandled.length()) break block4;
            UnicodeSet uniset = this.fHandled.get(breakType);
            int c = CharacterIteration.current32(text2);
            if (reverse) {
                while (text2.getIndex() > startPos && uniset.contains(c)) {
                    CharacterIteration.previous32(text2);
                    c = CharacterIteration.current32(text2);
                }
            } else {
                while (text2.getIndex() < endPos && uniset.contains(c)) {
                    CharacterIteration.next32(text2);
                    c = CharacterIteration.current32(text2);
                }
            }
        }
        return 0;
    }

    public void handleChar(int c, int breakType) {
        UnicodeSet originalSet;
        if (breakType >= 0 && breakType < this.fHandled.length() && c != Integer.MAX_VALUE && !(originalSet = this.fHandled.get(breakType)).contains(c)) {
            int script = UCharacter.getIntPropertyValue(c, 4106);
            UnicodeSet newSet = new UnicodeSet();
            newSet.applyIntPropertyValue(4106, script);
            newSet.addAll(originalSet);
            this.fHandled.set(breakType, newSet);
        }
    }
}

