/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Indexer;
import org.python27.indexer.NBinding;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NName;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnionType;
import org.python27.indexer.types.NUnknownType;

public class NAttribute
extends NNode {
    static final long serialVersionUID = -1120979305017812255L;
    public NNode target;
    public NName attr;

    public NAttribute(NNode target, NName attr) {
        this(target, attr, 0, 1);
    }

    public NAttribute(NNode target, NName attr, int start, int end) {
        super(start, end);
        this.setTarget(target);
        this.setAttr(attr);
        this.addChildren(target, attr);
    }

    public String getAttributeName() {
        return this.attr.id;
    }

    public void setAttr(NName attr) {
        if (attr == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.attr = attr;
    }

    public NName getAttr() {
        return this.attr;
    }

    public void setTarget(NNode target) {
        if (target == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.target = target;
    }

    public NNode getTarget() {
        return this.target;
    }

    public void setAttr(Scope s, NType v) throws Exception {
        this.setType(new NUnknownType());
        NType targetType = NAttribute.resolveExpr(this.target, s);
        if (targetType.isUnionType() && (targetType = targetType.asUnionType().firstKnownNonNullAlternate()) == null) {
            return;
        }
        if ((targetType = targetType.follow()) == Indexer.idx.builtins.None) {
            return;
        }
        NBinding b = targetType.getTable().putAttr(this.attr.id, this.attr, v, NBinding.Kind.ATTRIBUTE);
        if (b != null) {
            this.setType(this.attr.setType(b.followType()));
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        this.setType(new NUnknownType());
        NType targetType = NAttribute.resolveExpr(this.target, s);
        if (targetType.isUnionType()) {
            NType ret = new NUnknownType();
            for (NType tp : targetType.asUnionType().getTypes()) {
                this.resolveAttributeOnType(tp);
                ret = NUnionType.union(ret, this.getType());
            }
            this.setType(this.attr.setType(ret.follow()));
        } else {
            this.resolveAttributeOnType(targetType);
        }
        return this.getType();
    }

    private void resolveAttributeOnType(NType targetType) {
        NType ttype = targetType.follow();
        NBinding b = ttype.getTable().lookupAttr(this.attr.id);
        if (b == null) {
            b = this.makeProvisionalBinding(ttype);
        }
        if (b != null) {
            Indexer.idx.putLocation(this.attr, b);
            this.setType(this.attr.setType(b.getType()));
        }
    }

    private NBinding makeProvisionalBinding(NType targetType) {
        if (targetType.isNative()) {
            return null;
        }
        Scope targetScope = targetType.getTable();
        if ("".equals(targetScope.getPath())) {
            return null;
        }
        NUnknownType utype = new NUnknownType();
        NBinding b = targetScope.putAttr(this.attr.id, null, utype, NBinding.Kind.ATTRIBUTE);
        if (b != null) {
            b.setProvisional(true);
            utype.getTable().setPath(b.getQname());
        }
        return b;
    }

    public String toString() {
        return "<Attribute:" + this.start() + ":" + this.target + "." + this.getAttributeName() + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.target, v);
            this.visitNode(this.attr, v);
        }
    }
}

