/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python27.indexer.Indexer;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;

public class NBlock
extends NNode {
    static final long serialVersionUID = -9096405259154069107L;
    public List<NNode> seq;

    public NBlock(List<NNode> seq) {
        this(seq, 0, 1);
    }

    public NBlock(List<NNode> seq, int start, int end) {
        super(start, end);
        if (seq == null) {
            seq = new ArrayList<NNode>();
        }
        this.seq = seq;
        this.addChildren(seq);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        for (NNode n : this.seq) {
            NType returnType = NBlock.resolveExpr(n, scope);
            if (returnType == Indexer.idx.builtins.None) continue;
            this.setType(returnType);
        }
        return this.getType();
    }

    public String toString() {
        return "<Block:" + this.seq + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.seq, v);
        }
    }
}

