/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.util.List;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnknownType;

public class NBoolOp
extends NNode {
    static final long serialVersionUID = -5261954056600388069L;
    OpType op;
    public List<NNode> values;

    public NBoolOp(OpType op, List<NNode> values) {
        this(op, values, 0, 1);
    }

    public NBoolOp(OpType op, List<NNode> values, int start, int end) {
        super(start, end);
        this.op = op;
        this.values = values;
        this.addChildren(values);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        if (this.op == OpType.AND) {
            NType last = null;
            for (NNode e : this.values) {
                last = NBoolOp.resolveExpr(e, s);
            }
            return this.setType(last == null ? new NUnknownType() : last);
        }
        return this.setType(this.resolveListAsUnion(this.values, s));
    }

    public String toString() {
        return "<BoolOp:" + (Object)((Object)this.op) + ":" + this.values + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.values, v);
        }
    }

    public static enum OpType {
        AND,
        OR,
        UNDEFINED;

    }
}

