/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.util.List;
import org.python27.indexer.Indexer;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;

public class NCompare
extends NNode {
    static final long serialVersionUID = 1013460919393985064L;
    public NNode left;
    public List<NNode> ops;
    public List<NNode> comparators;

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators) {
        this(left, ops, comparators, 0, 1);
    }

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators, int start, int end) {
        super(start, end);
        this.left = left;
        this.ops = ops;
        this.comparators = comparators;
        this.addChildren(left);
        this.addChildren(ops);
        this.addChildren(comparators);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        this.setType(Indexer.idx.builtins.BaseNum);
        NCompare.resolveExpr(this.left, s);
        this.resolveList(this.comparators, s);
        return this.getType();
    }

    public String toString() {
        return "<Compare:" + this.left + ":" + this.ops + ":" + this.comparators + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.left, v);
            this.visitNodeList(this.ops, v);
            this.visitNodeList(this.comparators, v);
        }
    }
}

