/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Scope;
import org.python27.indexer.ast.NBlock;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.ast.NameBinder;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnknownType;

public class NExceptHandler
extends NNode {
    static final long serialVersionUID = 6215262228266158119L;
    public NNode name;
    public NNode exceptionType;
    public NBlock body;

    public NExceptHandler(NNode name, NNode exceptionType, NBlock body) {
        this(name, exceptionType, body, 0, 1);
    }

    public NExceptHandler(NNode name, NNode exceptionType, NBlock body, int start, int end) {
        super(start, end);
        this.name = name;
        this.exceptionType = exceptionType;
        this.body = body;
        this.addChildren(name, exceptionType, body);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        if (this.name != null) {
            NameBinder.make().bind(s, this.name, (NType)new NUnknownType());
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NType typeval = new NUnknownType();
        if (this.exceptionType != null) {
            typeval = NExceptHandler.resolveExpr(this.exceptionType, s);
        }
        if (this.name != null) {
            NameBinder.make().bind(s, this.name, typeval);
        }
        if (this.body != null) {
            return this.setType(NExceptHandler.resolveExpr(this.body, s));
        }
        return this.setType(new NUnknownType());
    }

    public String toString() {
        return "<ExceptHandler:" + this.start() + ":" + this.name + ":" + this.exceptionType + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.name, v);
            this.visitNode(this.exceptionType, v);
            this.visitNode(this.body, v);
        }
    }
}

