/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;

public class NExec
extends NNode {
    static final long serialVersionUID = -1840017898177850339L;
    public NNode body;
    public NNode globals;
    public NNode locals;

    public NExec(NNode body, NNode globals, NNode locals) {
        this(body, globals, locals, 0, 1);
    }

    public NExec(NNode body, NNode globals, NNode locals, int start, int end) {
        super(start, end);
        this.body = body;
        this.globals = globals;
        this.locals = locals;
        this.addChildren(body, globals, locals);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NExec.resolveExpr(this.body, s);
        NExec.resolveExpr(this.globals, s);
        NExec.resolveExpr(this.locals, s);
        return this.getType();
    }

    public String toString() {
        return "<Exec:" + this.start() + ":" + this.end() + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.body, v);
            this.visitNode(this.globals, v);
            this.visitNode(this.locals, v);
        }
    }
}

