/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Scope;
import org.python27.indexer.ast.NBlock;
import org.python27.indexer.ast.NName;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.ast.NSequence;
import org.python27.indexer.ast.NameBinder;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnknownType;

public class NFor
extends NNode {
    static final long serialVersionUID = 3228529969554646406L;
    public NNode target;
    public NNode iter;
    public NBlock body;
    public NBlock orelse;

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse) {
        this(target, iter, body, orelse, 0, 1);
    }

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(target, iter, body, orelse);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        this.bindNames(s, this.target, NameBinder.make());
    }

    private void bindNames(Scope s, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            for (NNode n : ((NSequence)target).getElements()) {
                this.bindNames(s, n, binder);
            }
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NameBinder.make().bindIter(s, this.target, this.iter);
        if (this.body == null) {
            this.setType(new NUnknownType());
        } else {
            this.setType(NFor.resolveExpr(this.body, s));
        }
        if (this.orelse != null) {
            this.addType(NFor.resolveExpr(this.orelse, s));
        }
        return this.getType();
    }

    public String toString() {
        return "<For:" + this.target + ":" + this.iter + ":" + this.body + ":" + this.orelse + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.target, v);
            this.visitNode(this.iter, v);
            this.visitNode(this.body, v);
            this.visitNode(this.orelse, v);
        }
    }
}

