/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.util.List;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.ast.NSequence;
import org.python27.indexer.types.NListType;
import org.python27.indexer.types.NType;

public class NList
extends NSequence {
    static final long serialVersionUID = 6623743056841822992L;

    public NList(List<NNode> elts) {
        this(elts, 0, 1);
    }

    public NList(List<NNode> elts, int start, int end) {
        super(elts, start, end);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        if (this.elts.size() == 0) {
            return this.setType(new NListType());
        }
        NListType listType = null;
        for (NNode elt : this.elts) {
            if (listType == null) {
                listType = new NListType(NList.resolveExpr(elt, s));
                continue;
            }
            listType.add(NList.resolveExpr(elt, s));
        }
        if (listType != null) {
            this.setType(listType);
        }
        return this.getType();
    }

    public String toString() {
        return "<List:" + this.start() + ":" + this.elts + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.elts, v);
        }
    }
}

