/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Indexer;
import org.python27.indexer.NBinding;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NAttribute;
import org.python27.indexer.ast.NCall;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnknownType;

public class NName
extends NNode {
    static final long serialVersionUID = -1160862551327528304L;
    public final String id;

    public NName(String id) {
        this(id, 0, 1);
    }

    public NName(String id, int start, int end) {
        super(start, end);
        if (id == null) {
            throw new IllegalArgumentException("'id' param cannot be null");
        }
        this.id = id;
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NBinding b = s.lookup(this.id);
        if (b == null) {
            b = this.makeTempBinding(s);
        }
        Indexer.idx.putLocation(this, b);
        return this.setType(b.followType());
    }

    @Override
    public boolean isCall() {
        NNode gramps;
        if (this.parent != null && this.parent.isCall() && this == ((NCall)this.parent).func) {
            return true;
        }
        return this.parent instanceof NAttribute && this == ((NAttribute)this.parent).attr && (gramps = this.parent.parent) instanceof NCall && this.parent == ((NCall)gramps).func;
    }

    private NBinding makeTempBinding(Scope s) {
        Scope scope = s.getScopeSymtab();
        NBinding b = scope.put(this.id, this, new NUnknownType(), NBinding.Kind.SCOPE);
        this.setType(b.getType().follow());
        this.getTable().setPath(scope.extendPath(this.id));
        return b;
    }

    public boolean isAttribute() {
        return this.parent instanceof NAttribute && ((NAttribute)this.parent).getAttr() == this;
    }

    public String toString() {
        return "<Name:" + this.start() + ":" + this.id + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        v.visit(this);
    }
}

