/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.io.Serializable;
import java.util.List;
import org.python27.indexer.Indexer;
import org.python27.indexer.IndexingException;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.GenericNodeVisitor;
import org.python27.indexer.ast.NCall;
import org.python27.indexer.ast.NModule;
import org.python27.indexer.ast.NName;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnionType;
import org.python27.indexer.types.NUnknownType;

public abstract class NNode
implements Serializable {
    static final long serialVersionUID = 3682719481356964898L;
    private int start = 0;
    private int end = 1;
    protected NNode parent = null;
    private transient NType type;

    public NNode() {
        this.type = Indexer.idx.builtins.None;
    }

    public NNode(int start, int end) {
        this.type = Indexer.idx.builtins.None;
        this.setStart(start);
        this.setEnd(end);
    }

    public void setParent(NNode parent) {
        this.parent = parent;
    }

    public NNode getParent() {
        return this.parent;
    }

    public NNode getAstRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getAstRoot();
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public Scope getTable() {
        return this.getType().getTable();
    }

    public NType getType() {
        if (this.type == null) {
            this.type = Indexer.idx.builtins.None;
        }
        return this.type;
    }

    public NType setType(NType newType) {
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        this.type = newType;
        return this.type;
    }

    public NType addType(NType newType) {
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        this.type = NUnionType.union(this.getType(), newType);
        return this.type;
    }

    public boolean bindsName() {
        return false;
    }

    protected void bindNames(Scope s) throws Exception {
        throw new UnsupportedOperationException("Not a name-binding node type");
    }

    public String getFile() {
        return this.parent != null ? this.parent.getFile() : null;
    }

    public void addChildren(NNode ... nodes) {
        if (nodes != null) {
            for (NNode n : nodes) {
                if (n == null) continue;
                n.setParent(this);
            }
        }
    }

    public void addChildren(List<? extends NNode> nodes) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                if (nNode == null) continue;
                nNode.setParent(this);
            }
        }
    }

    private static NType handleExceptionInResolve(NNode n, Throwable t) {
        Indexer.idx.handleException("Unable to resolve: " + n + " in " + n.getFile(), t);
        return new NUnknownType();
    }

    public static NType resolveExpr(NNode n, Scope s) {
        if (n == null) {
            return new NUnknownType();
        }
        try {
            NType result2 = n.resolve(s);
            if (result2 == null) {
                Indexer.idx.warn(n + " resolved to a null type");
                return n.setType(new NUnknownType());
            }
            return result2;
        }
        catch (IndexingException ix) {
            throw ix;
        }
        catch (Exception x) {
            return NNode.handleExceptionInResolve(n, x);
        }
        catch (StackOverflowError soe) {
            String msg2 = "Unable to resolve: " + n + " in " + n.getFile() + " (stack overflow)";
            Indexer.idx.warn(msg2);
            return NNode.handleExceptionInResolve(n, soe);
        }
    }

    public NType resolve(Scope s) throws Exception {
        return this.getType();
    }

    public boolean isCall() {
        return this instanceof NCall;
    }

    public boolean isModule() {
        return this instanceof NModule;
    }

    public boolean isClassDef() {
        return false;
    }

    public boolean isFunctionDef() {
        return false;
    }

    public boolean isLambda() {
        return false;
    }

    public boolean isName() {
        return this instanceof NName;
    }

    protected void visitNode(NNode n, NNodeVisitor v) {
        if (n != null) {
            n.visit(v);
        }
    }

    protected void visitNodeList(List<? extends NNode> nodes, NNodeVisitor v) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                if (nNode == null) continue;
                nNode.visit(v);
            }
        }
    }

    public abstract void visit(NNodeVisitor var1);

    public Scope getEnclosingNamespace() {
        if (this.parent == null || this.isModule()) {
            return Indexer.idx.globaltable;
        }
        NNode up = this;
        while ((up = up.parent) != null) {
            if (!up.isFunctionDef() && !up.isClassDef() && !up.isModule()) continue;
            NType type = up.getType();
            if (type == null || type.getTable() == null) {
                return Indexer.idx.globaltable;
            }
            return type.getTable();
        }
        return Indexer.idx.globaltable;
    }

    protected void addWarning(String msg2) {
        Indexer.idx.putProblem(this, msg2);
    }

    protected void addWarning(NNode loc, String msg2) {
        Indexer.idx.putProblem(loc, msg2);
    }

    protected void addError(String msg2) {
        Indexer.idx.putProblem(this, msg2);
    }

    protected void addError(NNode loc, String msg2) {
        Indexer.idx.putProblem(loc, msg2);
    }

    protected NType resolveListAsUnion(List<? extends NNode> nodes, Scope s) {
        if (nodes == null || nodes.isEmpty()) {
            return new NUnknownType();
        }
        NType result2 = null;
        for (NNode nNode : nodes) {
            NType nodeType = NNode.resolveExpr(nNode, s);
            if (result2 == null) {
                result2 = nodeType;
                continue;
            }
            result2 = NUnionType.union(result2, nodeType);
        }
        return result2;
    }

    protected void resolveList(List<? extends NNode> nodes, Scope s) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                NNode.resolveExpr(nNode, s);
            }
        }
    }

    public NNode getDeepestNodeAtOffset(int sourceOffset) {
        NNode ast2 = this.getAstRoot();
        DeepestOverlappingNodeFinder finder = new DeepestOverlappingNodeFinder(sourceOffset);
        try {
            ast2.visit(finder);
        }
        catch (NNodeVisitor.StopIterationException stopIterationException) {
            // empty catch block
        }
        return finder.getNode();
    }

    static class DeepestOverlappingNodeFinder
    extends GenericNodeVisitor {
        private int offset;
        private NNode deepest;

        public DeepestOverlappingNodeFinder(int offset) {
            this.offset = offset;
        }

        public NNode getNode() {
            return this.deepest;
        }

        @Override
        public boolean dispatch(NNode node) {
            if (this.offset > node.end) {
                return false;
            }
            if (this.offset >= node.start && this.offset <= node.end) {
                this.deepest = node;
                return true;
            }
            throw new NNodeVisitor.StopIterationException();
        }
    }
}

