/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import java.util.List;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;

public class NPrint
extends NNode {
    static final long serialVersionUID = 689872588518071148L;
    public NNode dest;
    public List<NNode> values;

    public NPrint(NNode dest, List<NNode> elts) {
        this(dest, elts, 0, 1);
    }

    public NPrint(NNode dest, List<NNode> elts, int start, int end) {
        super(start, end);
        this.dest = dest;
        this.values = elts;
        this.addChildren(dest);
        this.addChildren(elts);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NPrint.resolveExpr(this.dest, s);
        this.resolveList(this.values, s);
        return this.getType();
    }

    public String toString() {
        return "<Print:" + this.values + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.dest, v);
            this.visitNodeList(this.values, v);
        }
    }
}

