/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Scope;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;

public class NRaise
extends NNode {
    static final long serialVersionUID = 5384576775167988640L;
    public NNode exceptionType;
    public NNode inst;
    public NNode traceback;

    public NRaise(NNode exceptionType, NNode inst, NNode traceback2) {
        this(exceptionType, inst, traceback2, 0, 1);
    }

    public NRaise(NNode exceptionType, NNode inst, NNode traceback2, int start, int end) {
        super(start, end);
        this.exceptionType = exceptionType;
        this.inst = inst;
        this.traceback = traceback2;
        this.addChildren(exceptionType, inst, traceback2);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NRaise.resolveExpr(this.exceptionType, s);
        NRaise.resolveExpr(this.inst, s);
        NRaise.resolveExpr(this.traceback, s);
        return this.getType();
    }

    public String toString() {
        return "<Raise:" + this.traceback + ":" + this.exceptionType + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.exceptionType, v);
            this.visitNode(this.inst, v);
            this.visitNode(this.traceback, v);
        }
    }
}

