/*
 * Decompiled with CFR 0.152.
 */
package org.python27.indexer.ast;

import org.python27.indexer.Indexer;
import org.python27.indexer.Scope;
import org.python27.indexer.ast.NIndex;
import org.python27.indexer.ast.NNode;
import org.python27.indexer.ast.NNodeVisitor;
import org.python27.indexer.types.NType;
import org.python27.indexer.types.NUnknownType;

public class NSubscript
extends NNode {
    static final long serialVersionUID = -493854491438387425L;
    public NNode value;
    public NNode slice;

    public NSubscript(NNode value, NNode slice2) {
        this(value, slice2, 0, 1);
    }

    public NSubscript(NNode value, NNode slice2, int start, int end) {
        super(start, end);
        this.value = value;
        this.slice = slice2;
        this.addChildren(value, slice2);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NType vt = NSubscript.resolveExpr(this.value, s);
        NType st = NSubscript.resolveExpr(this.slice, s);
        if (vt.isUnknownType()) {
            if (st.isListType()) {
                return this.setType(vt);
            }
            return this.setType(new NUnknownType());
        }
        if (st.isListType()) {
            NType getslice_type = vt.getTable().lookupTypeAttr("__getslice__");
            if (getslice_type == null) {
                this.addError("The type can't be sliced: " + vt);
                return this.setType(new NUnknownType());
            }
            if (!getslice_type.isFuncType()) {
                this.addError("The type's __getslice__ method is not a function: " + getslice_type);
                return this.setType(new NUnknownType());
            }
            return this.setType(getslice_type.asFuncType().getReturnType().follow());
        }
        if (this.slice instanceof NIndex) {
            if (vt.isListType()) {
                this.warnUnlessNumIndex(st);
                return this.setType(vt.asListType().getElementType());
            }
            if (vt.isTupleType()) {
                this.warnUnlessNumIndex(st);
                return this.setType(vt.asTupleType().toListType().getElementType());
            }
            if (vt.isStrType()) {
                this.warnUnlessNumIndex(st);
                return this.setType(Indexer.idx.builtins.BaseStr);
            }
            if (vt.isDictType()) {
                if (!st.follow().equals(vt.asDictType().getKeyType())) {
                    this.addWarning("Possible KeyError (wrong type for subscript)");
                }
                return this.setType(vt.asDictType().getValueType());
            }
        }
        if (vt.isUnionType()) {
            for (NType u : vt.asUnionType().getTypes()) {
                NType gt = vt.getTable().lookupTypeAttr("__getitem__");
                if (gt == null) continue;
                return this.setType(this.get__getitem__type(gt, gt));
            }
        }
        NType gt = vt.getTable().lookupTypeAttr("__getitem__");
        return this.setType(this.get__getitem__type(gt, vt));
    }

    private void warnUnlessNumIndex(NType subscriptType) {
        NType follow = subscriptType.follow();
        if (!follow.isNumType() && !follow.isUnknownType()) {
            this.addWarning("Possible KeyError: subscript should be a number; found " + follow);
        }
    }

    private NType get__getitem__type(NType gt, NType vt) {
        if (gt == null) {
            this.addError("indexing type without __getitem__ method: " + vt);
            return new NUnknownType();
        }
        if (!gt.isFuncType()) {
            this.addError("The type's __getitem__ method is not a function: " + gt);
            return new NUnknownType();
        }
        return gt.asFuncType().getReturnType().follow();
    }

    public String toString() {
        return "<Subscript:" + this.value + ":" + this.slice + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.value, v);
            this.visitNode(this.slice, v);
        }
    }
}

