/*
 * Decompiled with CFR 0.152.
 */
package org.python27.jsr223;

import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.python27.core.Py;
import org.python27.core.PyCode;
import org.python27.core.PyException;
import org.python27.core.PyList;
import org.python27.core.PyModule;
import org.python27.core.PyObject;
import org.python27.core.PyTraceback;
import org.python27.core.__builtin__;
import org.python27.jsr223.PyScriptEngineScope;
import org.python27.util.PythonInterpreter;

public class PyScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable,
AutoCloseable {
    private final PythonInterpreter interp;
    private final ScriptEngineFactory factory;

    PyScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.interp = PythonInterpreter.threadLocalStateInterpreter(new PyScriptEngineScope(this, this.context));
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(this.compileScript(script, context), context);
    }

    private Object eval(PyCode code2, ScriptContext context) throws ScriptException {
        try {
            this.interp.setIn(context.getReader());
            this.interp.setOut(context.getWriter());
            this.interp.setErr(context.getErrorWriter());
            this.interp.setLocals(new PyScriptEngineScope(this, context));
            String filename = (String)context.getAttribute("javax.script.filename");
            String[] argv = (String[])context.getAttribute("javax.script.argv");
            if (argv != null || filename != null) {
                PyList pyargv = new PyList();
                if (filename != null) {
                    pyargv.append(Py.java2py(filename));
                }
                if (argv != null) {
                    for (int i = 0; i < argv.length; ++i) {
                        pyargv.append(Py.java2py(argv[i]));
                    }
                }
                this.interp.getSystemState().argv = pyargv;
            }
            return this.interp.eval(code2).__tojava__(Object.class);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.compileScript(reader, context), context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new PyCompiledScript(this.compileScript(script, this.context));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return new PyCompiledScript(this.compileScript(reader, this.context));
    }

    private PyCode compileScript(String script, ScriptContext context) throws ScriptException {
        try {
            String filename = (String)context.getAttribute("javax.script.filename");
            if (filename == null) {
                return this.interp.compile(script);
            }
            this.interp.getLocals().__setitem__(Py.newString("__file__"), (PyObject)Py.newString(filename));
            return this.interp.compile(script, filename);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    private PyCode compileScript(Reader reader, ScriptContext context) throws ScriptException {
        try {
            String filename = (String)context.getAttribute("javax.script.filename");
            if (filename == null) {
                return this.interp.compile(reader);
            }
            this.interp.getLocals().__setitem__(Py.newString("__file__"), (PyObject)Py.newString(filename));
            return this.interp.compile(reader, filename);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            PyObject method;
            this.interp.setLocals(new PyScriptEngineScope(this, this.context));
            if (!(thiz instanceof PyObject)) {
                thiz = Py.java2py(thiz);
            }
            if ((method = ((PyObject)thiz).__findattr__(name)) == null) {
                throw new NoSuchMethodException(name);
            }
            PyObject result2 = args != null ? method.__call__(Py.javas2pys(args)) : method.__call__();
            return result2.__tojava__(Object.class);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            this.interp.setLocals(new PyScriptEngineScope(this, this.context));
            PyObject function = this.interp.get(name);
            if (function == null) {
                throw new NoSuchMethodException(name);
            }
            PyObject result2 = args != null ? function.__call__(Py.javas2pys(args)) : function.__call__();
            return result2.__tojava__(Object.class);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.getInterface(new PyModule("__jsr223__", this.interp.getLocals()), clazz);
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("object expected");
        }
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface expected");
        }
        this.interp.setLocals(new PyScriptEngineScope(this, this.context));
        final PyObject thiz = Py.java2py(obj);
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    PyScriptEngine.this.interp.setLocals(new PyScriptEngineScope(PyScriptEngine.this, PyScriptEngine.this.context));
                    PyObject pyMethod = thiz.__findattr__(method.getName());
                    if (pyMethod == null) {
                        throw new NoSuchMethodException(method.getName());
                    }
                    PyObject result2 = args != null ? pyMethod.__call__(Py.javas2pys(args)) : pyMethod.__call__();
                    return result2.__tojava__(Object.class);
                }
                catch (PyException pye) {
                    throw PyScriptEngine.scriptException(pye);
                }
            }
        });
        return (T)proxy;
    }

    private static ScriptException scriptException(PyException pye) {
        ScriptException se = null;
        try {
            pye.normalize();
            PyObject type = pye.type;
            PyObject value = pye.value;
            PyTraceback tb = pye.traceback;
            if (__builtin__.isinstance(value, Py.SyntaxError)) {
                PyObject filename = value.__findattr__("filename");
                PyObject lineno = value.__findattr__("lineno");
                PyObject offset = value.__findattr__("offset");
                value = value.__findattr__("msg");
                se = new ScriptException(Py.formatException(type, value), filename == null ? "<script>" : filename.toString(), lineno == null ? 0 : lineno.asInt(), offset == null ? 0 : offset.asInt());
            } else if (tb != null) {
                String filename = tb.tb_frame == null || tb.tb_frame.f_code == null ? null : tb.tb_frame.f_code.co_filename;
                se = new ScriptException(Py.formatException(type, value), filename, tb.tb_lineno);
            } else {
                se = new ScriptException(Py.formatException(type, value));
            }
            se.initCause(pye);
            return se;
        }
        catch (Exception ee) {
            se = new ScriptException(pye);
            return se;
        }
    }

    @Override
    public void close() {
        this.interp.close();
    }

    private class PyCompiledScript
    extends CompiledScript {
        private PyCode code;

        PyCompiledScript(PyCode code2) {
            this.code = code2;
        }

        @Override
        public ScriptEngine getEngine() {
            return PyScriptEngine.this;
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            return PyScriptEngine.this.eval(this.code, ctx);
        }
    }
}

