/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules;

import org.python27.core.Py;
import org.python27.core.PyFile;
import org.python27.core.PyInteger;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.PyType;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.core.__builtin__;
import org.python27.modules.PyIOFile;
import org.python27.modules.cStringIO;

public class PyIOFileFactory {
    private static PyType FileType = PyType.fromClass(PyFile.class);

    private PyIOFileFactory() {
    }

    public static PyIOFile createIOFile(PyObject file) {
        Object f = file.__tojava__(cStringIO.StringIO.class);
        if (f != Py.NoConversion) {
            return new cStringIOFile(file);
        }
        if (__builtin__.isinstance(file, FileType)) {
            return new FileIOFile(file);
        }
        return new ObjectIOFile(file);
    }

    static class ObjectIOFile
    implements PyIOFile,
    Traverseproc {
        char[] charr = new char[1];
        StringBuilder buff = new StringBuilder();
        PyObject write;
        PyObject read;
        PyObject readline;
        final int BUF_SIZE = 256;

        ObjectIOFile(PyObject file) {
            this.write = file.__findattr__("write");
            this.read = file.__findattr__("read");
            this.readline = file.__findattr__("readline");
        }

        @Override
        public void write(String str) {
            this.buff.append(str);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        @Override
        public void write(char ch) {
            this.buff.append(ch);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        @Override
        public void flush() {
            this.write.__call__(new PyString(this.buff.toString()));
            this.buff.setLength(0);
        }

        @Override
        public String read(int len) {
            return this.read.__call__(new PyInteger(len)).toString();
        }

        @Override
        public String readlineNoNl() {
            String line = this.readline.__call__().toString();
            return line.substring(0, line.length() - 1);
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal;
            if (this.write != null && (retVal = visit.visit(this.write, arg)) != 0) {
                return retVal;
            }
            if (this.read != null && (retVal = visit.visit(this.read, arg)) != 0) {
                return retVal;
            }
            return this.readline == null ? 0 : visit.visit(this.readline, arg);
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return ob != null && (ob == this.write || ob == this.read || ob == this.readline);
        }
    }

    static class FileIOFile
    implements PyIOFile,
    Traverseproc {
        PyFile file;

        FileIOFile(PyObject file) {
            this.file = (PyFile)file.__tojava__(PyFile.class);
            if (this.file.getClosed()) {
                throw Py.ValueError("I/O operation on closed file");
            }
        }

        @Override
        public void write(String str) {
            this.file.write(str);
        }

        @Override
        public void write(char ch) {
            this.file.write(cStringIO.getString(ch));
        }

        @Override
        public void flush() {
        }

        @Override
        public String read(int len) {
            return this.file.read(len).toString();
        }

        @Override
        public String readlineNoNl() {
            String line = this.file.readline().toString();
            return line.substring(0, line.length() - 1);
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            return this.file == null ? 0 : visit.visit(this.file, arg);
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return ob != null && ob == this.file;
        }
    }

    static class cStringIOFile
    implements PyIOFile {
        cStringIO.StringIO file;

        cStringIOFile(PyObject file) {
            this.file = (cStringIO.StringIO)file.__tojava__(Object.class);
        }

        @Override
        public void write(String str) {
            this.file.write(str);
        }

        @Override
        public void write(char ch) {
            this.file.writeChar(ch);
        }

        @Override
        public void flush() {
        }

        @Override
        public String read(int len) {
            return this.file.read(len).asString();
        }

        @Override
        public String readlineNoNl() {
            return this.file.readlineNoNl().asString();
        }
    }
}

