/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules._locale;

import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.python27.core.Py;
import org.python27.core.PyDictionary;
import org.python27.core.PyException;
import org.python27.core.PyInteger;
import org.python27.core.PyList;
import org.python27.core.PyString;
import org.python27.core.PyUnicode;
import org.python27.modules._locale.DateSymbolJyLocale;
import org.python27.modules._locale.PyLocale;
import org.python27.modules._locale._locale;

public class JyLocale
extends DateSymbolJyLocale
implements PyLocale {
    private final String encoding;
    private final PyDictionary conv;
    private final Collator collator;

    public JyLocale(Locale locale2, String encoding) {
        super(locale2);
        this.encoding = encoding;
        this.conv = this.initLocaleConv();
        this.collator = Collator.getInstance(locale2);
    }

    @Override
    public PyDictionary localeconv() {
        return this.conv;
    }

    private PyDictionary initLocaleConv() {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(this.locale);
        DecimalFormat cf = (DecimalFormat)NumberFormat.getCurrencyInstance(this.locale);
        return JyLocale.localeConvForFormat(df, cf, this.getEncoding());
    }

    static PyDictionary localeConvForFormat(DecimalFormat decimalFormat, DecimalFormat currencyFormat, String encoding) {
        PyDictionary result2 = new PyDictionary();
        DecimalFormatSymbols dfs = decimalFormat.getDecimalFormatSymbols();
        DecimalFormatSymbols cfs = currencyFormat.getDecimalFormatSymbols();
        JyLocale.putConvUnicodeEntry(result2, "decimal_point", dfs.getDecimalSeparator(), ".", encoding);
        JyLocale.putConvUnicodeEntry(result2, "thousands_sep", dfs.getGroupingSeparator(), "", encoding);
        JyLocale.putConvUnicodeEntry(result2, "currency_symbol", cfs.getCurrencySymbol(), dfs.getInternationalCurrencySymbol(), encoding);
        _locale.putConvEntry(result2, "int_curr_symbol", cfs.getInternationalCurrencySymbol());
        JyLocale.putConvUnicodeEntry(result2, "negative_sign", cfs.getMinusSign(), "-", encoding);
        _locale.putConvEntry(result2, "positive_sign", new PyString(""));
        _locale.putConvEntry(result2, "p_sign_posn", new PyInteger(3));
        PyList groupingList = new PyList();
        groupingList.add(new PyInteger(decimalFormat.getGroupingSize()));
        groupingList.add(new PyInteger(0));
        _locale.putConvEntry(result2, "grouping", groupingList);
        _locale.putConvEntry(result2, "mon_decimal_point", cfs.getMonetaryDecimalSeparator());
        JyLocale.putConvUnicodeEntry(result2, "mon_thousands_sep", cfs.getGroupingSeparator(), "", encoding);
        _locale.putConvEntry(result2, "frac_digits", new PyInteger(currencyFormat.getMaximumFractionDigits()));
        _locale.putConvEntry(result2, "int_frac_digits", new PyInteger(currencyFormat.getMaximumFractionDigits()));
        PyList monGroupingList = new PyList();
        monGroupingList.add(new PyInteger(currencyFormat.getGroupingSize()));
        monGroupingList.add(new PyInteger(0));
        _locale.putConvEntry(result2, "mon_grouping", monGroupingList);
        _locale.putConvEntry(result2, "n_sign_posn", new PyInteger(JyLocale.negativeSignPosition(currencyFormat)));
        _locale.putConvEntry(result2, "p_cs_precedes", new PyInteger(JyLocale.positiveCurrencyPrecedesValue(currencyFormat)));
        _locale.putConvEntry(result2, "n_cs_precedes", new PyInteger(JyLocale.negativeCurrencyPrecedesValue(currencyFormat)));
        _locale.putConvEntry(result2, "p_sep_by_space", new PyInteger(JyLocale.positiveSeparatedBySpace(currencyFormat)));
        _locale.putConvEntry(result2, "n_sep_by_space", new PyInteger(JyLocale.negativeSeparatedBySpace(currencyFormat)));
        return result2;
    }

    private static void putConvUnicodeEntry(PyDictionary result2, String key, String value, String fallback, String encoding) {
        try {
            result2.put(new PyString(key), new PyString(new PyUnicode(value).encode(encoding)));
        }
        catch (PyException pye) {
            JyLocale.encodingFallback(result2, key, fallback, pye);
        }
    }

    private static void putConvUnicodeEntry(PyDictionary result2, String key, char value, String fallback, String encoding) {
        try {
            result2.put(new PyString(key), new PyString(new PyUnicode(value).encode(encoding)));
        }
        catch (PyException pye) {
            JyLocale.encodingFallback(result2, key, fallback, pye);
        }
    }

    private static void encodingFallback(PyDictionary result2, String key, String fallback, PyException pye) {
        Py.writeComment("_locale", "Could not encode value for key " + key + " " + pye.getMessage());
        result2.put(new PyString(key), new PyString(fallback));
    }

    @Override
    public PyString getLocaleString() {
        return new PyString(this.locale.toString() + "." + this.encoding);
    }

    @Override
    public PyString getUnderlyingLocale() {
        return new PyString(this.locale.toString());
    }

    @Override
    public int strcoll(PyString str1, PyString str2) {
        return this.collator.compare(this.unicoder(str1), this.unicoder(str2));
    }

    private String unicoder(PyString str) {
        return this.strxfrm(str).toString();
    }

    @Override
    public PyString strxfrm(PyString str) {
        if (str instanceof PyUnicode) {
            return str;
        }
        return (PyString)str.decode(this.encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    static int negativeSignPosition(DecimalFormat df) {
        String prefix = df.getNegativePrefix();
        String suffix = df.getNegativeSuffix();
        if ("".equals(suffix) && "".equals(prefix)) {
            return 127;
        }
        if (prefix.startsWith("(") && suffix.endsWith(")")) {
            return 0;
        }
        String MINUS = String.valueOf(df.getDecimalFormatSymbols().getMinusSign());
        if (prefix.startsWith(MINUS)) {
            return 1;
        }
        if (prefix.endsWith(MINUS)) {
            return 3;
        }
        if (suffix.startsWith(MINUS)) {
            return 4;
        }
        return 2;
    }

    static int positiveCurrencyPrecedesValue(DecimalFormat df) {
        return JyLocale.currencyPrecedesValue(df, df.getPositivePrefix());
    }

    static int negativeCurrencyPrecedesValue(DecimalFormat df) {
        return JyLocale.currencyPrecedesValue(df, df.getNegativePrefix());
    }

    private static int currencyPrecedesValue(DecimalFormat df, String prefix) {
        if (prefix.contains(df.getDecimalFormatSymbols().getCurrencySymbol())) {
            return 1;
        }
        return 0;
    }

    static int positiveSeparatedBySpace(DecimalFormat df) {
        return JyLocale.separatedBySpace(df.getPositivePrefix(), df.getPositiveSuffix());
    }

    static int negativeSeparatedBySpace(DecimalFormat df) {
        return JyLocale.separatedBySpace(df.getNegativePrefix(), df.getNegativeSuffix());
    }

    private static int separatedBySpace(String prefix, String suffix) {
        if (!prefix.isEmpty() && JyLocale.isExtendedWhitespace(prefix.charAt(prefix.length() - 1))) {
            return 1;
        }
        if (!suffix.isEmpty() && JyLocale.isExtendedWhitespace(suffix.charAt(0))) {
            return 1;
        }
        return 0;
    }

    public static boolean isExtendedWhitespace(char c) {
        return Character.isWhitespace(c) || '\u00a0' == c;
    }
}

