/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules._locale;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.python27.core.Py;
import org.python27.core.PyCode;
import org.python27.core.PyDictionary;
import org.python27.core.PyException;
import org.python27.core.PyInteger;
import org.python27.core.PyObject;
import org.python27.core.PySet;
import org.python27.core.PyString;
import org.python27.core.PyStringMap;
import org.python27.core.PySystemState;
import org.python27.core.PyUnicode;
import org.python27.modules._locale.JyLocale;
import org.python27.modules._locale._locale;
import org.python27.util.PythonInterpreter;

public class _localeTest {
    private PySystemState systemState;
    private PythonInterpreter interp;

    @Before
    public void setUp() throws Exception {
        this.systemState = Py.getSystemState();
        this.interp = new PythonInterpreter(new PyStringMap(), this.systemState);
    }

    private void setLocaleProperty(String value) {
        PySystemState.registry.setProperty("python.locale.control", value);
    }

    private void defaultState() {
        this.setLocaleProperty("");
    }

    private void jython2LegacyState() {
        this.setLocaleProperty("jython2_legacy");
    }

    private void settableState() {
        this.setLocaleProperty("settable");
    }

    private void importAndInit() {
        this.interp.exec("import _locale");
        this.interp.exec("_locale.classDictInit({})");
    }

    private void settableInit() {
        this.settableState();
        this.importAndInit();
    }

    private void assertPyTrue(String variableName) {
        PyObject result2 = this.interp.get(variableName);
        Assert.assertEquals((Object)Py.True, (Object)result2);
    }

    private void assertPyEquals(int expected, String valueName) {
        PyObject result2 = this.interp.get(valueName);
        Assert.assertEquals((Object)new PyInteger(expected), (Object)result2);
    }

    private void assertPyEquals(String expected, String valueName) {
        PyObject result2 = this.interp.get(valueName);
        Assert.assertEquals((Object)new PyString(expected), (Object)result2);
    }

    private void assertInterpEquals(String expected, String value) {
        PyObject result1 = this.interp.get(expected);
        PyObject result2 = this.interp.get(value);
        Assert.assertEquals((Object)result1, (Object)result2);
    }

    @Test
    public void moduleImportSettable() {
        this.settableInit();
        PyObject _localeModule = this.interp.get("_locale");
        Assert.assertNotNull((Object)_localeModule);
    }

    @Test(expected=PyException.class)
    public void moduleImportLegacy() {
        this.jython2LegacyState();
        this.importAndInit();
    }

    @Test(expected=PyException.class)
    public void moduleImportDefault() {
        this.defaultState();
        this.importAndInit();
    }

    private static int javaMajorVersion() {
        String versionString = System.getProperty("java.runtime.version");
        String[] javaVersionElements = versionString.split("\\.|_|-b");
        int major = Integer.valueOf(javaVersionElements[0]);
        int minor = Integer.valueOf(javaVersionElements[1]);
        if (major == 1) {
            return minor;
        }
        return major;
    }

    public void setLocaleEN_US(String tag) {
        this.settableInit();
        int nSignPosition = 0;
        if (_localeTest.javaMajorVersion() >= 9) {
            nSignPosition = 1;
        }
        String script = "from _locale import setlocale, localeconv\nsetlocale(_locale.LC_ALL, '" + tag + "' ) \nexpected = {'mon_decimal_point': '.', 'int_frac_digits': 2,  'p_sep_by_space': 0, 'frac_digits': 2,  'thousands_sep': ',',  'n_sign_posn': " + String.valueOf(nSignPosition) + " , 'decimal_point': '.', 'int_curr_symbol': 'USD', 'n_cs_precedes': 1, 'p_sign_posn': 3, 'mon_thousands_sep': ',', 'negative_sign': '-', 'currency_symbol': '$', 'n_sep_by_space': 0 , 'positive_sign': '', 'p_cs_precedes': 1  } \nactual = localeconv() \ngrouping = actual.pop('grouping',None) \nmon_grouping = actual.pop('mon_grouping',None) \nresult = set( actual.items() ) ^ set(expected.items()) \nresultGrouping = (grouping == [3,0] )  \nresultMonGrouping = (mon_grouping == [3,0]  ) \n";
        this.interp.exec(script);
        PyObject result2 = this.interp.get("result");
        Assert.assertEquals((Object)new PySet(), (Object)result2);
        this.assertPyTrue("resultGrouping");
        this.assertPyTrue("resultMonGrouping");
    }

    @Test
    public void setLocaleEN_US_Underscore() {
        this.setLocaleEN_US("en_US.ISO8859-1");
    }

    @Test
    public void setLocaleEN_US_Dash() {
        this.setLocaleEN_US("en-US");
    }

    @Test
    public void setLocaleEN_US_Tuple() {
        this.settableInit();
        String script = "from locale import setlocale, getlocale, LC_ALL \nsetlocale(LC_ALL,('en-US','ISO8859-1') ) \nactual = getlocale() \nexpected = ('en_US', 'ISO8859-1') \n";
        PyCode code2 = this.interp.compile(script);
        this.interp.exec(code2);
        this.assertInterpEquals("expected", "actual");
    }

    @Test
    public void setLocaleNotLCALL() {
        this.settableInit();
        String script = "import locale \ncaught = False \ntry: \n    locale.setlocale(locale.LC_MONETARY,'zh-CN') \nexcept locale.Error as e: \n    caught = True \n";
        this.interp.exec(script);
        this.assertPyTrue("caught");
    }

    @Test
    public void setLocaleEmpty() {
        this.settableInit();
        String script = "from _locale import setlocale \nsetlocale(_locale.LC_ALL,'zh_CN.UTF-8') \nresult1 = setlocale(_locale.LC_ALL) \nresult2 = setlocale(_locale.LC_MONETARY,None) \nresult3 = setlocale(_locale.LC_MONETARY,'zh_CN.UTF-8') \n";
        this.interp.exec(script);
        this.assertPyEquals("zh_CN.UTF-8", "result1");
        this.assertPyEquals("zh_CN.UTF-8", "result2");
        this.assertPyEquals("zh_CN.UTF-8", "result3");
    }

    @Test
    public void setLocaleDefault() {
        this.settableInit();
        String script = "from locale import setlocale \nresult1 = setlocale(_locale.LC_ALL,'zh_CN.UTF-8') \nresult2 = setlocale(_locale.LC_ALL,'') ";
        this.interp.exec(script);
        this.assertPyEquals("zh_CN.UTF-8", "result1");
        this.assertPyEquals(Locale.getDefault().toString() + "." + Charset.defaultCharset().name(), "result2");
    }

    @Test(expected=PyException.class)
    public void setLocaleInvalid() {
        this.settableInit();
        String script = "from _locale import setlocale \nresult = setlocale(_locale.LC_ALL,'green_midget_cafe_nosuch') \n";
        this.interp.exec(script);
    }

    @Test
    public void setLocaleGerman() {
        this.settableInit();
        String script = "from _locale import setlocale, localeconv\nsetlocale(_locale.LC_ALL,'de_DE.ISO8859-15') \nexpected = {'mon_decimal_point': ',', 'int_frac_digits': 2,  'p_sep_by_space': 1, 'frac_digits': 2, 'thousands_sep': '.', 'n_sign_posn': 1, 'decimal_point': ',', 'int_curr_symbol': 'EUR', 'n_cs_precedes': 0, 'p_sign_posn': 3, 'mon_thousands_sep': '.', 'negative_sign': '-', 'currency_symbol':  '\\xa4' , 'n_sep_by_space': 1, 'p_cs_precedes': 0, 'positive_sign': ''} \nactual = localeconv() \ngrouping = actual.pop('grouping',None) \nmon_grouping = actual.pop('mon_grouping',None) \nresult = set( actual.items() ) ^ set(expected.items()) \nresultGrouping = (grouping == [3,0] )  \nresultMonGrouping = (mon_grouping == [3,0]  ) \n";
        PyCode code2 = this.interp.compile(script);
        this.interp.exec(code2);
        PyObject result2 = this.interp.get("result");
        Assert.assertEquals((Object)new PySet(), (Object)result2);
        this.assertPyTrue("resultGrouping");
        this.assertPyTrue("resultMonGrouping");
    }

    @Test
    public void setLocaleChinaMainland() {
        this.settableInit();
        String script = "from _locale import setlocale, localeconv\nsetlocale(_locale.LC_ALL,'zh_CN.UTF-8') \nexpected = {'mon_decimal_point': '.', 'int_frac_digits': 2,  'p_sep_by_space': 0, 'frac_digits': 2, 'thousands_sep': ',', 'n_sign_posn': 1, 'decimal_point': '.', 'int_curr_symbol': 'CNY', 'n_cs_precedes': 1, 'p_sign_posn': 3, 'mon_thousands_sep': ',', 'negative_sign': '-', 'currency_symbol':  '\\xef\\xbf\\xa5' , 'n_sep_by_space': 0, 'p_cs_precedes': 1, 'positive_sign': ''} \nactual = localeconv() \ngrouping = actual.pop('grouping',None) \nmon_grouping = actual.pop('mon_grouping',None) \nresult = set( actual.items() ) ^ set(expected.items()) \nresultGrouping = (grouping == [3,0] )  \nresultMonGrouping = (mon_grouping == [3,0]  ) \n";
        PyCode code2 = this.interp.compile(script);
        this.interp.exec(code2);
        PyObject result2 = this.interp.get("result");
        Assert.assertEquals((Object)new PySet(), (Object)result2);
        this.assertPyTrue("resultGrouping");
        this.assertPyTrue("resultMonGrouping");
    }

    @Test
    public void setlocaleJPEncodingCurrencyFallback() {
        this.settableInit();
        String script = "from _locale import setlocale, localeconv\nsetlocale(_locale.LC_ALL,'ja_JP.ISO8859-1') \nresult = localeconv()['currency_symbol']  \n";
        this.interp.exec(script);
        PyObject result2 = this.interp.get("result");
        Assert.assertEquals((Object)new PyString("JPY"), (Object)result2);
    }

    private String byteStr(byte[] bytes, boolean lePadding) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append("~h");
            sb.append(Integer.toHexString(bytes[i]));
            if (!lePadding) continue;
            sb.append("~h0");
        }
        return sb.toString();
    }

    private String utf16LEByteStr(String in, boolean lePadding) {
        return this.byteStr(in.getBytes(StandardCharsets.UTF_16LE), lePadding);
    }

    private void assertDictValueEquals(PyDictionary dict, String expectedValue, String key) {
        Assert.assertEquals((Object)new PyUnicode(expectedValue), (Object)dict.__getitem__(new PyString(key)));
    }

    private void assertDictUTF16LEEquals(PyDictionary dict, String expectedStr, String key) {
        PyString value = (PyString)dict.__getitem__(new PyString(key));
        Assert.assertEquals((Object)this.utf16LEByteStr(expectedStr, true), (Object)this.utf16LEByteStr(value.getString(), false));
    }

    @Test
    public void utf16EncodingAndFallback() {
        Locale unicodeMockLocale = new Locale.Builder().setLanguage("zh").setRegion("FI").build();
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(unicodeMockLocale);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setMinusSign('\u2212');
        dfs.setGroupingSeparator('\u65e0');
        dfs.setDecimalSeparator('\u70b9');
        df.setDecimalFormatSymbols(dfs);
        PyDictionary dict = JyLocale.localeConvForFormat(df, df, "ISO8859-1");
        this.assertDictValueEquals(dict, "-", "negative_sign");
        this.assertDictValueEquals(dict, ".", "decimal_point");
        this.assertDictValueEquals(dict, "", "thousands_sep");
        this.assertDictValueEquals(dict, "", "mon_thousands_sep");
        dict = JyLocale.localeConvForFormat(df, df, "utf-16le");
        this.assertDictUTF16LEEquals(dict, "\u2212", "negative_sign");
        this.assertDictUTF16LEEquals(dict, "\u70b9", "decimal_point");
        this.assertDictUTF16LEEquals(dict, "\u65e0", "thousands_sep");
        this.assertDictUTF16LEEquals(dict, "\u65e0", "mon_thousands_sep");
    }

    @Test
    public void negativeSignPosition() {
        Locale locale2 = Locale.forLanguageTag("en-US");
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        df.setNegativePrefix("($");
        df.setNegativeSuffix(")");
        Assert.assertEquals((long)0L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("-");
        df.setNegativeSuffix("EUR");
        Assert.assertEquals((long)1L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("");
        df.setNegativeSuffix("SPAM-");
        Assert.assertEquals((long)2L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("FCFA-");
        df.setNegativeSuffix("");
        Assert.assertEquals((long)3L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("CHF");
        df.setNegativeSuffix("-");
        Assert.assertEquals((long)4L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("\u00a4 ");
        df.setNegativeSuffix("-");
        Assert.assertEquals((long)4L, (long)JyLocale.negativeSignPosition(df));
        df.setNegativePrefix("");
        df.setNegativeSuffix("");
        Assert.assertEquals((long)127L, (long)JyLocale.negativeSignPosition(df));
    }

    @Test
    public void positiveCurrencyPrecedesValue() {
        Locale locale2 = Locale.forLanguageTag("en-US");
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        df.setPositivePrefix("$");
        df.setPositiveSuffix("");
        Assert.assertEquals((long)1L, (long)JyLocale.positiveCurrencyPrecedesValue(df));
        df.setPositivePrefix("");
        df.setPositiveSuffix(" $");
        Assert.assertEquals((long)0L, (long)JyLocale.positiveCurrencyPrecedesValue(df));
    }

    @Test
    public void negativeCurrencyPrecedesValue() {
        Locale locale2 = Locale.forLanguageTag("en-US");
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        df.setNegativePrefix("($");
        df.setNegativeSuffix(")");
        Assert.assertEquals((long)1L, (long)JyLocale.negativeCurrencyPrecedesValue(df));
        df.setNegativePrefix("");
        df.setNegativeSuffix(" $");
        Assert.assertEquals((long)0L, (long)JyLocale.negativeCurrencyPrecedesValue(df));
    }

    @Test
    public void positiveSeparatedBySpace() {
        Locale locale2 = Locale.forLanguageTag("en-US");
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        df.setPositivePrefix("$");
        df.setPositiveSuffix("");
        Assert.assertEquals((long)0L, (long)JyLocale.positiveSeparatedBySpace(df));
        df.setPositivePrefix("");
        df.setPositiveSuffix(" CHF");
        Assert.assertEquals((long)1L, (long)JyLocale.positiveSeparatedBySpace(df));
    }

    @Test
    public void negativeSeparatedBySpace() {
        Locale locale2 = Locale.forLanguageTag("de-DE");
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        Assert.assertEquals((long)1L, (long)JyLocale.negativeSeparatedBySpace(df));
        df.setNegativePrefix("");
        df.setNegativeSuffix("\u00a0\u20ac");
        Assert.assertEquals((long)1L, (long)JyLocale.negativeSeparatedBySpace(df));
        df.setNegativePrefix("");
        df.setNegativeSuffix(" EUR");
        Assert.assertEquals((long)1L, (long)JyLocale.negativeSeparatedBySpace(df));
        df.setNegativePrefix("-$");
        df.setNegativeSuffix("");
        Assert.assertEquals((long)0L, (long)JyLocale.negativeSeparatedBySpace(df));
    }

    @Test
    public void extendedWhitespace() {
        Assert.assertTrue((boolean)JyLocale.isExtendedWhitespace(' '));
        Assert.assertFalse((boolean)JyLocale.isExtendedWhitespace('a'));
        Assert.assertTrue((boolean)JyLocale.isExtendedWhitespace('\u00a0'));
        Assert.assertFalse((boolean)JyLocale.isExtendedWhitespace('\u20ac'));
    }

    @Test
    public void getlocale() {
        this.settableInit();
        String script = "from locale import normalize, setlocale, getlocale, LC_ALL, LC_NUMERIC\nnorm = normalize('zh_CN') \nsetlocale(LC_ALL,('zh_CN',None)) \nactual = getlocale() \nexpected = ('zh_CN', 'gb2312') \n";
        PyCode code2 = this.interp.compile(script);
        this.interp.exec(code2);
        PyObject norm = this.interp.get("norm");
        Assert.assertEquals((Object)new PyString("zh_CN.gb2312"), (Object)norm);
        PyObject actual = this.interp.get("actual");
        PyObject expected = this.interp.get("expected");
        Assert.assertEquals((Object)expected, (Object)actual);
        script = "actual = getlocale(LC_NUMERIC) \n";
        this.interp.exec(script);
        actual = this.interp.get("actual");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void setlocaleC() {
        this.settableInit();
        String script = "from locale import setlocale, getlocale, localeconv, LC_ALL\nsetlocale(LC_ALL,'C') \nactualLocale = getlocale() \nactual = localeconv() \nexpected = {   'mon_decimal_point': '', 'int_frac_digits': 127,   'p_sep_by_space': 127, 'frac_digits': 127,   'thousands_sep': '', 'n_sign_posn': 127,   'decimal_point': '.', 'int_curr_symbol': '',   'n_cs_precedes': 127, 'p_sign_posn': 127,   'mon_thousands_sep': '', 'negative_sign': '',   'currency_symbol': '', 'n_sep_by_space': 127,   'p_cs_precedes': 127, 'positive_sign': '' } \nexpectedLocale = (None,None) \ngrouping = actual.pop('grouping',None) \nmon_grouping = actual.pop('mon_grouping',None) \nresult = set( actual.items() ) ^ set(expected.items()) \nresultGrouping = (grouping == [] )  \nresultMonGrouping = (mon_grouping == []  ) \n";
        this.interp.exec(script);
        this.assertInterpEquals("expectedLocale", "actualLocale");
        PyObject result2 = this.interp.get("result");
        Assert.assertEquals((Object)new PySet(), (Object)result2);
        this.assertPyTrue("resultGrouping");
        this.assertPyTrue("resultMonGrouping");
    }

    @Test
    public void strCompareUS() {
        this.settableInit();
        _locale.setlocale(_locale.LC_ALL, new PyString("en_US"));
        Assert.assertEquals((long)-1L, (long)_locale.strcoll(new PyString("aaa"), new PyString("baa")));
        Assert.assertEquals((long)1L, (long)_locale.strcoll(new PyString("baa"), new PyString("aaa")));
        Assert.assertEquals((long)0L, (long)_locale.strcoll(new PyString("knight"), new PyString("knight")));
    }

    @Test
    public void strCompareChineseMainlandInterp() {
        Py.writeDebug("_localeTest", "strCompareCMI()");
        this.settableInit();
        String script = "from _locale import setlocale, LC_ALL, strcoll \nsetlocale(LC_ALL, 'zh_CN.UTF-8'  ) \nresultSame = strcoll( u'\\u4e00', u'\\u4e00' ) \nresultLvsU = strcoll( '\\xe4\\xb8\\x80', u'\\u4e00' ) \nresultAscii = strcoll( 'b', 'a' ) \nresultUltU1 = strcoll( u'\\u4e00', u'\\u5f00' ) \nresultUltU2 = strcoll( u'\\u597d', u'\\u4e00' ) \n";
        this.interp.exec(script);
        this.assertPyEquals(0, "resultSame");
        this.assertPyEquals(0, "resultLvsU");
        this.assertPyEquals(1, "resultAscii");
        this.assertPyEquals(1, "resultUltU1");
        this.assertPyEquals(-1, "resultUltU2");
    }

    @Test
    public void strCompareC() {
        Py.writeDebug("_localeTest", "strCompareC()");
        this.settableInit();
        String script = "from locale import setlocale, LC_ALL, strcoll \nsetlocale(LC_ALL, 'C' ) \nresult1 = strcoll( 'a', 'b' ) \nresult2 = strcoll( 'b', 'a' ) \n";
        this.interp.exec(script);
        this.assertPyEquals(-1, "result1");
        this.assertPyEquals(1, "result2");
    }

    @Test
    public void strxfrm() {
        Py.writeDebug("_localeTest", "strxfrm()");
        this.settableInit();
        String script = "from _locale import setlocale, LC_ALL, strxfrm \nsetlocale(LC_ALL, 'zh_CN.UTF-8'  ) \nresultU = strxfrm( u'\\u4e00') \nresultL = strxfrm( '\\xe4\\xb8\\x80' ) \nresult1 = (resultU == u'\\u4e00')  \nresult2 = (resultU == resultL)  \n";
        this.interp.exec(script);
        this.assertPyTrue("result1");
        this.assertPyTrue("result2");
    }

    @Test
    public void dateSymbols() {
        this.settableInit();
        String script = "from locale import setlocale, LC_ALL \nfrom datetime import datetime \nsetlocale(LC_ALL, 'C' ) \nresultC = datetime(2019,04,15,15, 56, 44).strftime('%c') \nsetlocale(LC_ALL, 'de_DE' ) \nresultD = datetime(1919,05,16,15, 56, 44).strftime('%A %Y') \n";
        this.interp.exec(script);
        this.assertPyEquals("Mon Apr 15 15:56:44 2019", "resultC");
        this.assertPyEquals("Freitag 1919", "resultD");
    }
}

