/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules._threading;

import org.python27.core.ContextManager;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyNewWrapper;
import org.python27.core.PyObject;
import org.python27.core.PyTuple;
import org.python27.core.PyType;
import org.python27.core.ThreadState;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.modules._threading.Condition$PyExposer;
import org.python27.modules._threading.ConditionSupportingLock;
import org.python27.modules._threading.RLock;

@ExposedType(name="_threading.Condition")
public class Condition
extends PyObject
implements ContextManager,
Traverseproc {
    public static final PyType TYPE;
    private final ConditionSupportingLock _lock;
    private final java.util.concurrent.locks.Condition _condition;

    public Condition() {
        this(new RLock());
    }

    public Condition(ConditionSupportingLock lock) {
        this._lock = lock;
        this._condition = lock.getLock().newCondition();
    }

    @ExposedNew
    static final PyObject Condition___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs == 1) {
            return new Condition((ConditionSupportingLock)((Object)args[0]));
        }
        return new Condition();
    }

    public boolean acquire() {
        return this.Condition_acquire(true);
    }

    public boolean acquire(boolean blocking) {
        return this.Condition_acquire(blocking);
    }

    final boolean Condition_acquire(boolean blocking) {
        return this._lock.acquire(blocking);
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this._lock.acquire();
        return this;
    }

    final PyObject Condition___enter__() {
        this.Condition_acquire(true);
        return this;
    }

    public void release() {
        this.Condition_release();
    }

    final void Condition_release() {
        this._lock.release();
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this._lock.release();
        return false;
    }

    final boolean Condition___exit__(PyObject type, PyObject value, PyObject traceback2) {
        this.Condition_release();
        return false;
    }

    public void wait$(PyObject timeout) throws InterruptedException {
        this.Condition_wait(timeout);
    }

    final void Condition_wait(PyObject timeout) throws InterruptedException {
        try {
            if (timeout == Py.None) {
                this._condition.await();
            } else {
                long nanos = (long)(timeout.asDouble() * 1.0E9);
                this._condition.awaitNanos(nanos);
            }
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot wait on un-acquired lock");
        }
    }

    public void notify$() {
        this.Condition_notify(1);
    }

    final void Condition_notify(int count2) {
        try {
            for (int i = 0; i < count2; ++i) {
                this._condition.signal();
            }
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    public void notifyAll$() {
        this.Condition_notifyAll();
    }

    final void Condition_notifyAll() {
        try {
            this._condition.signalAll();
        }
        catch (IllegalMonitorStateException ex) {
            throw Py.RuntimeError("cannot notify on un-acquired lock");
        }
    }

    final void Condition_notify_all() {
        this._condition.signalAll();
    }

    public boolean _is_owned() {
        return this.Condition__is_owned();
    }

    final boolean Condition__is_owned() {
        return this._lock._is_owned();
    }

    @Override
    public String toString() {
        int count2 = 0;
        try {
            count2 = this._lock.getWaitQueueLength(this._condition);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
        return Py.newString("<_threading.Condition(%s, %d)>").__mod__(new PyTuple(Py.newString(this._lock.toString()), Py.newInteger(count2))).toString();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this._lock != null ? visit.visit((PyObject)((Object)this._lock), arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && this._lock == ob;
    }

    static {
        PyType.addBuilder(Condition.class, new Condition$PyExposer());
        TYPE = PyType.fromClass(Condition.class);
    }
}

