/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules._threading;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class Mutex
implements Lock {
    private final Sync sync = new Sync();

    Mutex() {
    }

    @Override
    public void lock() {
        this.sync.acquire(1);
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryAcquire(1);
    }

    @Override
    public void unlock() {
        this.sync.release(1);
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public boolean isLocked() {
        return this.sync.isHeldExclusively();
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition instanceof AbstractQueuedSynchronizer.ConditionObject) {
            return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
        }
        return 0;
    }

    String getOwnerName() {
        Thread owner = this.sync.getOwner();
        return owner != null ? owner.getName() : null;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        @Override
        public boolean tryAcquire(int acquires) {
            assert (acquires == 1);
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int releases) {
            assert (releases == 1);
            if (this.getState() == 0) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }
    }
}

