/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules._weakref;

import org.python27.core.ClassDictInit;
import org.python27.core.Py;
import org.python27.core.PyList;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.modules._weakref.CallableProxyType;
import org.python27.modules._weakref.GlobalRef;
import org.python27.modules._weakref.ProxyType;
import org.python27.modules._weakref.ReferenceBackend;
import org.python27.modules._weakref.ReferenceType;

public class WeakrefModule
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("Weak-reference support module.");

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__doc__", (PyObject)__doc__);
        dict.__setitem__("__name__", (PyObject)Py.newString("_weakref"));
        dict.__setitem__("ref", (PyObject)ReferenceType.TYPE);
        dict.__setitem__("ReferenceType", (PyObject)ReferenceType.TYPE);
        dict.__setitem__("ProxyType", (PyObject)ProxyType.TYPE);
        dict.__setitem__("CallableProxyType", (PyObject)CallableProxyType.TYPE);
        dict.__setitem__("classDictInit", null);
    }

    public static ProxyType proxy(PyObject object) {
        boolean callable;
        ReferenceBackend gref = GlobalRef.newInstance(object);
        ProxyType ret = (ProxyType)gref.find((callable = object.isCallable()) ? CallableProxyType.class : ProxyType.class);
        if (ret != null) {
            return ret;
        }
        if (callable) {
            return new CallableProxyType(GlobalRef.newInstance(object), null);
        }
        return new ProxyType(GlobalRef.newInstance(object), null);
    }

    public static ProxyType proxy(PyObject object, PyObject callback) {
        if (callback == Py.None) {
            return WeakrefModule.proxy(object);
        }
        if (object.isCallable()) {
            return new CallableProxyType(GlobalRef.newInstance(object), callback);
        }
        return new ProxyType(GlobalRef.newInstance(object), callback);
    }

    public static int getweakrefcount(PyObject object) {
        return GlobalRef.getCount(object);
    }

    public static PyList getweakrefs(PyObject object) {
        return GlobalRef.getRefs(object);
    }
}

