/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.itertools;

import java.util.Map;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyIterator;
import org.python27.core.PyNewWrapper;
import org.python27.core.PyObject;
import org.python27.core.PyType;
import org.python27.core.Visitproc;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.modules.itertools.PyTeeIterator$PyExposer;
import org.python27.util.Generic;

@ExposedType(name="itertools.tee", base=PyObject.class, isBaseType=false, doc="Iterator wrapped to make it copyable")
public class PyTeeIterator
extends PyIterator {
    public static final String tee_doc = "Iterator wrapped to make it copyable";
    private int position;
    private PyTeeData teeData;

    public PyTeeIterator() {
    }

    public PyTeeIterator(PyType subType) {
        super(subType);
    }

    public PyTeeIterator(PyTeeData teeData) {
        this.teeData = teeData;
    }

    @ExposedNew
    static final PyObject tee___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs < 1 || nargs > 1) {
            throw Py.TypeError("tee expected 1 arguments, got " + nargs);
        }
        return PyTeeIterator.fromIterable(args[0]);
    }

    public static PyObject[] makeTees(PyObject iterable, int n) {
        if (n < 0) {
            throw Py.ValueError("n must be >= 0");
        }
        PyObject[] tees = new PyObject[n];
        if (n == 0) {
            return tees;
        }
        PyObject copyFunc = iterable.__findattr__("__copy__");
        if (copyFunc == null) {
            tees[0] = PyTeeIterator.fromIterable(iterable);
            copyFunc = tees[0].__getattr__("__copy__");
        } else {
            tees[0] = iterable;
        }
        for (int i = 1; i < n; ++i) {
            tees[i] = copyFunc.__call__();
        }
        return tees;
    }

    private static PyTeeIterator fromIterable(PyObject iterable) {
        if (iterable instanceof PyTeeIterator) {
            return ((PyTeeIterator)iterable).tee___copy__();
        }
        PyObject iterator = iterable.__iter__();
        PyTeeData teeData = new PyTeeData(iterator);
        return new PyTeeIterator(teeData);
    }

    public final PyObject tee_next() {
        return this.next();
    }

    @Override
    public PyObject __iternext__() {
        PyObject obj;
        if ((obj = this.teeData.getItem(this.position++)) == null) {
            this.stopException = this.teeData.stopException;
        }
        return obj;
    }

    public final PyTeeIterator tee___copy__() {
        return new PyTeeIterator(this.teeData);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        if (this.teeData != null) {
            if (this.teeData.iterator != null && (retVal = visit.visit(this.teeData.iterator, arg)) != 0) {
                return retVal;
            }
            if (this.teeData.buffer != null) {
                for (PyObject ob : this.teeData.buffer.values()) {
                    if (ob == null || (retVal = visit.visit(ob, arg)) == 0) continue;
                    return retVal;
                }
            }
            if (this.teeData.stopException != null && (retVal = this.teeData.stopException.traverse(visit, arg)) != 0) {
                return retVal;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (ob == null) {
            return false;
        }
        if (super.refersDirectlyTo(ob)) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    static {
        PyType.addBuilder(PyTeeIterator.class, new PyTeeIterator$PyExposer());
    }

    private static class PyTeeData {
        private PyObject iterator;
        private int total;
        private Map<Integer, PyObject> buffer;
        public PyException stopException;
        private Object lock;

        public PyTeeData(PyObject iterator) {
            this.iterator = iterator;
            this.buffer = Generic.concurrentMap();
            this.total = 0;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PyObject getItem(int pos) {
            if (pos == this.total) {
                Object object = this.lock;
                synchronized (object) {
                    if (pos == this.total) {
                        PyObject obj = this.nextElement(this.iterator);
                        if (obj == null) {
                            return null;
                        }
                        this.buffer.put(this.total++, obj);
                    }
                }
            }
            return this.buffer.get(pos);
        }

        private PyObject nextElement(PyObject pyIter) {
            PyObject element = null;
            try {
                element = pyIter.__iternext__();
            }
            catch (PyException pyEx) {
                if (pyEx.match(Py.StopIteration)) {
                    this.stopException = pyEx;
                }
                throw pyEx;
            }
            return element;
        }
    }
}

