/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.itertools;

import org.python27.core.Py;
import org.python27.core.PyIterator;
import org.python27.core.PyObject;
import org.python27.core.PyTuple;
import org.python27.core.PyType;
import org.python27.core.Visitproc;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.modules.itertools.imap$PyExposer;

@ExposedType(name="itertools.imap", base=PyObject.class, doc="'map(func, *iterables) --> imap object\n\nMake an iterator that computes the function using arguments from\neach of the iterables.\tLike map() except that it returns\nan iterator instead of a list and that it stops when the shortest\niterable is exhausted instead of filling in None for shorter\niterables.")
public class imap
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String imap_doc = "'map(func, *iterables) --> imap object\n\nMake an iterator that computes the function using arguments from\neach of the iterables.\tLike map() except that it returns\nan iterator instead of a list and that it stops when the shortest\niterable is exhausted instead of filling in None for shorter\niterables.";

    public imap() {
    }

    public imap(PyType subType) {
        super(subType);
    }

    public imap(PyObject ... args) {
        this.imap___init__(args);
    }

    @ExposedNew
    final void imap___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError(String.format("imap does not take keyword arguments", new Object[0]));
        }
        this.imap___init__(args);
    }

    private void imap___init__(PyObject[] argstar) {
        if (argstar.length < 2) {
            throw Py.TypeError("imap requires at least two arguments");
        }
        final int n = argstar.length - 1;
        final PyObject func = argstar[0];
        final PyObject[] iterables = new PyObject[n];
        for (int j = 0; j < n; ++j) {
            iterables[j] = Py.iter(argstar[j + 1], "argument " + (j + 1) + " to imap() must support iteration");
        }
        this.iter = new PyIterator(){
            PyObject[] args;
            PyObject element;
            {
                this.args = new PyObject[n];
                this.element = null;
            }

            @Override
            public PyObject __iternext__() {
                for (int i = 0; i < n; ++i) {
                    this.element = iterables[i].__iternext__();
                    if (this.element == null) {
                        return null;
                    }
                    this.args[i] = this.element;
                }
                if (func == Py.None) {
                    if (n == 1) {
                        return this.args[0];
                    }
                    return new PyTuple((PyObject[])this.args.clone());
                }
                return func.__call__(this.args);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(imap.class, new imap$PyExposer());
        TYPE = PyType.fromClass(imap.class);
    }
}

