/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.itertools;

import org.python27.core.ClassDictInit;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyIterator;
import org.python27.core.PyNone;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.PyTuple;
import org.python27.core.Visitproc;
import org.python27.modules.itertools.PyTeeIterator;
import org.python27.modules.itertools.chain;
import org.python27.modules.itertools.combinations;
import org.python27.modules.itertools.combinationsWithReplacement;
import org.python27.modules.itertools.compress;
import org.python27.modules.itertools.count;
import org.python27.modules.itertools.cycle;
import org.python27.modules.itertools.dropwhile;
import org.python27.modules.itertools.groupby;
import org.python27.modules.itertools.ifilter;
import org.python27.modules.itertools.ifilterfalse;
import org.python27.modules.itertools.imap;
import org.python27.modules.itertools.islice;
import org.python27.modules.itertools.izip;
import org.python27.modules.itertools.izipLongest;
import org.python27.modules.itertools.permutations;
import org.python27.modules.itertools.product;
import org.python27.modules.itertools.repeat;
import org.python27.modules.itertools.starmap;
import org.python27.modules.itertools.takewhile;

public class itertools
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("Functional tools for creating and using iterators.\n\nInfinite iterators:\ncount([n]) --> n, n+1, n+2, ...\ncycle(p) --> p0, p1, ... plast, p0, p1, ...\nrepeat(elem [,n]) --> elem, elem, elem, ... endlessly or up to n times\n\nIterators terminating on the shortest input sequence:\nchain(p, q, ...) --> p0, p1, ... plast, q0, q1, ...\ncompress(data, selectors) --> (d[0] if s[0]), (d[1] if s[1]), ...\ndropwhile(pred, seq) --> seq[n], seq[n+1], starting when pred fails\ngroupby(iterable[, keyfunc]) --> sub-iterators grouped by value of keyfunc(v)\nifilter(pred, seq) --> elements of seq where pred(elem) is True\nifilterfalse(pred, seq) --> elements of seq where pred(elem) is False\nislice(seq, [start,] stop [, step]) --> elements from seq[start:stop:step]\nimap(fun, p, q, ...) --> fun(p0, q0), fun(p1, q1), ...\nstarmap(fun, seq) --> fun(*seq[0]), fun(*seq[1]), ...\ntee(it, n=2) --> (it1, it2 , ... itn) splits one iterator into n\ntakewhile(pred, seq) --> seq[0], seq[1], until pred fails\nizip(p, q, ...) --> (p[0], q[0]), (p[1], q[1]), ...\nizip_longest(p, q, ...) --> (p[0], q[0]), (p[1], q[1]), ...\n\nCombinatoric generators:\nproduct(p, q, ... [repeat=1]) --> cartesian product\npermutations(p[, r])\ncombinations(p, r)\ncombinations_with_replacement(p, r)");
    public static PyString __doc__tee = new PyString("tee(iterable, n=2) --> tuple of n independent iterators.");

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__name__", (PyObject)new PyString("itertools"));
        dict.__setitem__("__doc__", (PyObject)__doc__);
        dict.__setitem__("chain", (PyObject)chain.TYPE);
        dict.__setitem__("combinations", (PyObject)combinations.TYPE);
        dict.__setitem__("combinations_with_replacement", (PyObject)combinationsWithReplacement.TYPE);
        dict.__setitem__("compress", (PyObject)compress.TYPE);
        dict.__setitem__("cycle", (PyObject)cycle.TYPE);
        dict.__setitem__("count", (PyObject)count.TYPE);
        dict.__setitem__("dropwhile", (PyObject)dropwhile.TYPE);
        dict.__setitem__("groupby", (PyObject)groupby.TYPE);
        dict.__setitem__("imap", (PyObject)imap.TYPE);
        dict.__setitem__("ifilter", (PyObject)ifilter.TYPE);
        dict.__setitem__("ifilterfalse", (PyObject)ifilterfalse.TYPE);
        dict.__setitem__("islice", (PyObject)islice.TYPE);
        dict.__setitem__("izip", (PyObject)izip.TYPE);
        dict.__setitem__("izip_longest", (PyObject)izipLongest.TYPE);
        dict.__setitem__("permutations", (PyObject)permutations.TYPE);
        dict.__setitem__("product", (PyObject)product.TYPE);
        dict.__setitem__("repeat", (PyObject)repeat.TYPE);
        dict.__setitem__("starmap", (PyObject)starmap.TYPE);
        dict.__setitem__("takewhile", (PyObject)takewhile.TYPE);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("initClassExceptions", null);
    }

    static int py2int(PyObject obj, int defaultValue, String msg2) {
        if (obj instanceof PyNone) {
            return defaultValue;
        }
        int value = defaultValue;
        try {
            value = Py.py2int(obj);
        }
        catch (PyException pyEx) {
            if (pyEx.match(Py.TypeError)) {
                throw Py.ValueError(msg2);
            }
            throw pyEx;
        }
        return value;
    }

    public static PyTuple tee(PyObject iterable, int n) {
        return new PyTuple(PyTeeIterator.makeTees(iterable, n));
    }

    public static PyTuple tee(PyObject iterable) {
        return itertools.tee(iterable, 2);
    }

    static PyTuple makeIndexedTuple(PyTuple pool, int[] indices) {
        return itertools.makeIndexedTuple(pool, indices, indices.length);
    }

    static PyTuple makeIndexedTuple(PyTuple pool, int[] indices, int end) {
        PyObject[] items = new PyObject[end];
        for (int i = 0; i < end; ++i) {
            items[i] = pool.__getitem__(indices[i]);
        }
        return new PyTuple(items);
    }

    static class WhileIterator
    extends ItertoolsIterator {
        private PyObject iterator;
        private PyObject predicate;
        private boolean drop;
        private boolean predicateSatisfied;

        WhileIterator(PyObject predicate, PyObject iterable, boolean drop) {
            this.predicate = predicate;
            this.iterator = iterable.__iter__();
            this.drop = drop;
        }

        @Override
        public PyObject __iternext__() {
            PyObject element;
            while ((element = this.nextElement(this.iterator)) != null) {
                if (!this.predicateSatisfied) {
                    if (this.predicate.__call__(element).__nonzero__() != this.drop) {
                        this.predicateSatisfied = this.drop;
                        return element;
                    }
                    this.predicateSatisfied = !this.drop;
                    continue;
                }
                if (this.drop) {
                    return element;
                }
                return null;
            }
            return null;
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal = super.traverse(visit, arg);
            if (retVal != 0) {
                return retVal;
            }
            if (this.iterator != null && (retVal = visit.visit(this.iterator, arg)) != 0) {
                return retVal;
            }
            return this.predicate != null ? visit.visit(this.predicate, arg) : 0;
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return ob != null && (ob == this.iterator || ob == this.predicate || super.refersDirectlyTo(ob));
        }
    }

    static class FilterIterator
    extends ItertoolsIterator {
        private PyObject predicate;
        private PyObject iterator;
        private boolean filterTrue;

        FilterIterator(PyObject predicate, PyObject iterable, boolean filterTrue) {
            this.predicate = predicate instanceof PyNone ? null : predicate;
            this.iterator = iterable.__iter__();
            this.filterTrue = filterTrue;
        }

        @Override
        public PyObject __iternext__() {
            PyObject element;
            while ((element = this.nextElement(this.iterator)) != null) {
                boolean booleanValue = this.predicate != null ? this.predicate.__call__(element).__nonzero__() : element.__nonzero__();
                if (booleanValue != this.filterTrue) continue;
                return element;
            }
            return null;
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal = super.traverse(visit, arg);
            if (retVal != 0) {
                return retVal;
            }
            if (this.iterator != null && (retVal = visit.visit(this.iterator, arg)) != 0) {
                return retVal;
            }
            return this.predicate != null ? visit.visit(this.predicate, arg) : 0;
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return ob != null && (ob == this.iterator || ob == this.predicate || super.refersDirectlyTo(ob));
        }
    }

    static abstract class ItertoolsIterator
    extends PyIterator {
        ItertoolsIterator() {
        }

        protected PyObject nextElement(PyObject pyIter) {
            PyObject element = null;
            try {
                element = pyIter.__iternext__();
            }
            catch (PyException pyEx) {
                if (pyEx.match(Py.StopIteration)) {
                    this.stopException = pyEx;
                }
                throw pyEx;
            }
            return element;
        }
    }
}

