/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Type;
import org.python27.core.Py;
import org.python27.core.PyList;
import org.python27.core.PyNewWrapper;
import org.python27.core.PyObject;
import org.python27.core.PySequenceList;
import org.python27.core.PyStringMap;
import org.python27.core.PyType;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.modules.jffi.BasePointer;
import org.python27.modules.jffi.CType;
import org.python27.modules.jffi.DefaultInvokerFactory;
import org.python27.modules.jffi.DirectMemory;
import org.python27.modules.jffi.DynamicLibrary;
import org.python27.modules.jffi.Function$PyExposer;
import org.python27.modules.jffi.Invoker;
import org.python27.modules.jffi.JITCompiler;
import org.python27.modules.jffi.JITHandle;
import org.python27.modules.jffi.NativeDataConverter;
import org.python27.modules.jffi.Pointer;
import org.python27.modules.jffi.Util;

@ExposedType(name="jffi.Function", base=PyObject.class)
public class Function
extends BasePointer
implements Traverseproc {
    public static final PyType TYPE;
    private final Pointer pointer;
    private final DynamicLibrary library;
    private final PyStringMap dict = new PyStringMap();
    private volatile PyObject restype = CType.INT;
    private volatile PyObject[] argtypes = null;
    private Invoker defaultInvoker;
    private Invoker compiledInvoker;
    private volatile JITHandle jitHandle;
    private volatile com.kenai.jffi.Function jffiFunction;
    public PyObject errcheck = Py.None;
    public final String name;

    Function(PyType type, Pointer address) {
        super(type);
        this.library = null;
        this.name = "<anonymous>";
        this.pointer = address;
        this.restype = type.__getattr__("_restype");
    }

    Function(PyType type, DynamicLibrary.Symbol sym) {
        super(type);
        this.library = sym.library;
        this.name = sym.name;
        this.pointer = sym;
        this.restype = type.__getattr__("_restype");
    }

    @ExposedNew
    public static PyObject Function_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args[0] instanceof Pointer) {
            if (args[0] instanceof DynamicLibrary.Symbol) {
                return new Function(subtype, (DynamicLibrary.Symbol)args[0]);
            }
            return new Function(subtype, (Pointer)((Object)args[0]));
        }
        throw Py.TypeError("expected memory address");
    }

    @Override
    public DirectMemory getMemory() {
        return this.pointer.getMemory();
    }

    @Override
    public PyObject fastGetDict() {
        return this.dict;
    }

    @Override
    public PyObject getDict() {
        return this.dict;
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.getInvoker().invoke(args);
    }

    @Override
    public PyObject __call__() {
        return this.getInvoker().invoke();
    }

    @Override
    public PyObject __call__(PyObject arg0) {
        return this.getInvoker().invoke(arg0);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1) {
        return this.getInvoker().invoke(arg0, arg1);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.getInvoker().invoke(arg0, arg1, arg2);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.getInvoker().invoke(arg0, arg1, arg2, arg3);
    }

    public PyObject getResultType() {
        return this.restype;
    }

    public void setResultType(PyObject restype) {
        this.invalidateInvoker();
        this.restype = restype;
    }

    public PyObject getArgTypes() {
        return new PyList(this.argtypes != null ? this.argtypes : new PyObject[]{});
    }

    public void setArgTypes(PyObject parameterTypes) {
        this.invalidateInvoker();
        if (parameterTypes == Py.None) {
            this.argtypes = null;
            return;
        }
        if (!(parameterTypes instanceof PySequenceList)) {
            throw Py.TypeError("wrong argument type (expected list or tuple)");
        }
        PySequenceList paramList = (PySequenceList)parameterTypes;
        this.argtypes = new PyObject[paramList.size()];
        for (int i = 0; i < this.argtypes.length; ++i) {
            this.argtypes[i] = paramList.pyget(i);
        }
    }

    public void errcheck(PyObject errcheck) {
        this.invalidateInvoker();
        this.errcheck = errcheck;
    }

    @Override
    public boolean __nonzero__() {
        return !this.getMemory().isNull();
    }

    protected final Invoker getInvoker() {
        return this.compiledInvoker != null ? this.compiledInvoker : this.tryCompilation();
    }

    private synchronized Invoker tryCompilation() {
        Invoker invoker;
        if (this.compiledInvoker != null) {
            return this.compiledInvoker;
        }
        if (this.argtypes == null) {
            throw Py.NotImplementedError("variadic functions not supported yet;  specify a parameter list");
        }
        CType cResultType = CType.typeOf(this.restype);
        PyObject[] cParameterTypes = new CType[this.argtypes.length];
        for (int i = 0; i < cParameterTypes.length; ++i) {
            cParameterTypes[i] = CType.typeOf(this.argtypes[i]);
        }
        if (this.jitHandle == null) {
            this.jitHandle = JITCompiler.getInstance().getHandle(cResultType, cParameterTypes, CallingConvention.DEFAULT, false);
        }
        if (this.jffiFunction == null) {
            Type jffiReturnType = Util.jffiType(cResultType);
            Type[] jffiParamTypes = new Type[this.argtypes.length];
            for (int i = 0; i < jffiParamTypes.length; ++i) {
                jffiParamTypes[i] = Util.jffiType((CType)cParameterTypes[i]);
            }
            this.jffiFunction = new com.kenai.jffi.Function(this.getMemory().getAddress(), jffiReturnType, jffiParamTypes);
        }
        if (this.defaultInvoker == null) {
            Invoker invoker2 = DefaultInvokerFactory.getFactory().createInvoker(this.jffiFunction, this.restype, this.argtypes);
            Invoker invoker3 = this.defaultInvoker = this.errcheck != Py.None ? new ErrCheckInvoker(invoker2, this.errcheck) : invoker2;
        }
        if ((invoker = this.jitHandle.compile(this.jffiFunction, null, new NativeDataConverter[0])) != null) {
            this.compiledInvoker = this.errcheck != Py.None ? new ErrCheckInvoker(invoker, this.errcheck) : invoker;
            return this.compiledInvoker;
        }
        if (this.jitHandle.compilationFailed()) {
            this.compiledInvoker = this.defaultInvoker;
        }
        return this.defaultInvoker;
    }

    private synchronized void invalidateInvoker() {
        this.defaultInvoker = null;
        this.compiledInvoker = null;
        this.jitHandle = null;
        this.jffiFunction = null;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int res = 0;
        if (this.pointer != null && this.pointer instanceof PyObject && (res = visit.visit((PyObject)((Object)this.pointer), arg)) != 0) {
            return res;
        }
        if (this.dict != null && (res = visit.visit(this.dict, arg)) != 0) {
            return res;
        }
        if (this.restype != null && (res = visit.visit(this.restype, arg)) != 0) {
            return res;
        }
        if (this.argtypes != null) {
            for (PyObject obj : this.argtypes) {
                res = visit.visit(obj, arg);
                if (res == 0) continue;
                return res;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (ob != null && (this.pointer == ob || this.dict == ob || this.restype == ob)) {
            return true;
        }
        if (this.argtypes != null) {
            for (PyObject obj : this.argtypes) {
                if (obj != ob) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PyType.addBuilder(Function.class, new Function$PyExposer());
        TYPE = PyType.fromClass(Function.class);
    }

    private static final class ErrCheckInvoker
    extends Invoker {
        private final Invoker invoker;
        private final PyObject errcheck;

        public ErrCheckInvoker(Invoker invoker, PyObject errcheck) {
            this.invoker = invoker;
            this.errcheck = errcheck;
        }

        @Override
        public PyObject invoke(PyObject[] args) {
            return this.errcheck.__call__(this.invoker.invoke(args));
        }

        @Override
        public PyObject invoke() {
            return this.errcheck.__call__(this.invoker.invoke());
        }

        @Override
        public PyObject invoke(PyObject arg1) {
            return this.errcheck.__call__(this.invoker.invoke(arg1));
        }

        @Override
        public PyObject invoke(PyObject arg1, PyObject arg2) {
            return this.errcheck.__call__(this.invoker.invoke(arg1, arg2));
        }

        @Override
        public PyObject invoke(PyObject arg1, PyObject arg2, PyObject arg3) {
            return this.errcheck.__call__(this.invoker.invoke(arg1, arg2, arg3));
        }

        @Override
        public PyObject invoke(PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4) {
            return this.errcheck.__call__(this.invoker.invoke(arg1, arg2, arg3, arg4));
        }

        @Override
        public PyObject invoke(PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4, PyObject arg5) {
            return this.errcheck.__call__(this.invoker.invoke(arg1, arg2, arg3, arg4, arg5));
        }

        @Override
        public PyObject invoke(PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4, PyObject arg5, PyObject arg6) {
            return this.errcheck.__call__(this.invoker.invoke(arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }
}

