/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.posix;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.python27.core.PyObject;
import org.python27.modules.posix.OS;

class Hider {
    Hider() {
    }

    public static void hideFunctions(Class<?> cls, PyObject dict, OS os2, boolean isNative) {
        PosixImpl posixImpl = isNative ? PosixImpl.NATIVE : PosixImpl.JAVA;
        for (Method method : cls.getDeclaredMethods()) {
            if (!Hider.isHidden(method, os2, posixImpl)) continue;
            dict.__setitem__(method.getName(), null);
        }
    }

    private static boolean isHidden(Method method, OS os2, PosixImpl posixImpl) {
        if (method.isAnnotationPresent(Hide.class)) {
            Hide hide = method.getAnnotation(Hide.class);
            if (hide.posixImpl() != PosixImpl.NOT_APPLICABLE && hide.posixImpl() == posixImpl) {
                return true;
            }
            for (OS hideOS : hide.value()) {
                if (os2 != hideOS) continue;
                return true;
            }
        }
        return false;
    }

    static enum PosixImpl {
        NOT_APPLICABLE,
        NATIVE,
        JAVA;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface Hide {
        public OS[] value() default {};

        public PosixImpl posixImpl() default PosixImpl.NOT_APPLICABLE;
    }
}

