/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.random;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.python27.core.Py;
import org.python27.core.PyFloat;
import org.python27.core.PyInteger;
import org.python27.core.PyLong;
import org.python27.core.PyObject;
import org.python27.core.PyTuple;
import org.python27.core.PyType;
import org.python27.core.Untraversable;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.modules.random.PyRandom$PyExposer;

@Untraversable
@ExposedType(name="_random.Random")
public class PyRandom
extends PyObject {
    public static final PyType TYPE;
    protected Random javaRandom = new Random();

    public PyRandom() {
        this(TYPE);
    }

    public PyRandom(PyType subType) {
        super(subType);
    }

    final void Random_seed(PyObject seed) {
        long n;
        if (seed == null) {
            seed = new PyLong(System.currentTimeMillis());
        }
        if (seed instanceof PyLong) {
            PyLong max = new PyLong(Long.MAX_VALUE);
            n = seed.__mod__(max).asLong();
        } else {
            n = seed instanceof PyInteger ? seed.asLong() : (long)seed.hashCode();
        }
        this.javaRandom.setSeed(n);
    }

    @ExposedNew
    final void Random___init__(PyObject[] args, String[] keywords) {
    }

    final void Random_jumpahead(PyObject arg0) {
        if (!(arg0 instanceof PyInteger) && !(arg0 instanceof PyLong)) {
            throw Py.TypeError(String.format("jumpahead requires an integer, not '%s'", arg0.getType().fastGetName()));
        }
        for (long i = arg0.asLong(); i > 0L; --i) {
            this.javaRandom.nextInt();
        }
    }

    final void Random_setstate(PyObject arg0) {
        if (!(arg0 instanceof PyTuple)) {
            throw Py.TypeError("state vector must be a tuple");
        }
        try {
            Object[] arr = ((PyTuple)arg0).toArray();
            byte[] b = new byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof Integer)) {
                    throw Py.TypeError("state vector of unexpected type: " + arr[i].getClass());
                }
                b[i] = ((Integer)arr[i]).byteValue();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            ObjectInputStream oin = new ObjectInputStream(bin);
            this.javaRandom = (Random)oin.readObject();
        }
        catch (IOException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
    }

    final PyObject Random_getstate() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.javaRandom);
            byte[] b = bout.toByteArray();
            PyObject[] retarr = new PyInteger[b.length];
            for (int i = 0; i < b.length; ++i) {
                retarr[i] = new PyInteger(b[i]);
            }
            PyTuple ret = new PyTuple(retarr);
            return ret;
        }
        catch (IOException e) {
            throw Py.SystemError("creation of state vector failed: " + e.getMessage());
        }
    }

    final PyObject Random_random() {
        long a = this.javaRandom.nextInt() >>> 5;
        long b = this.javaRandom.nextInt() >>> 6;
        double ret = ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        return new PyFloat(ret);
    }

    final PyLong Random_getrandbits(int k) {
        return new PyLong(new BigInteger(k, this.javaRandom));
    }

    static {
        PyType.addBuilder(PyRandom.class, new PyRandom$PyExposer());
        TYPE = PyType.fromClass(PyRandom.class);
    }
}

