/*
 * Decompiled with CFR 0.152.
 */
package org.python27.modules.thread;

import org.python27.core.ContextManager;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyObject;
import org.python27.core.ThreadState;
import org.python27.core.Untraversable;

@Untraversable
public class PyLock
extends PyObject
implements ContextManager {
    private boolean locked = false;

    public boolean acquire() {
        return this.acquire(true);
    }

    public synchronized boolean acquire(boolean waitflag) {
        if (waitflag) {
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted thread");
                }
            }
            this.locked = true;
            return true;
        }
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    public synchronized void release() {
        if (!this.locked) {
            throw Py.ValueError("lock not acquired");
        }
        this.locked = false;
        this.notifyAll();
    }

    public boolean locked() {
        return this.locked;
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this.acquire();
        return this;
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this.release();
        return false;
    }
}

