/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.channel;

import org.python27.netty.buffer.ByteBuf;
import org.python27.netty.buffer.ByteBufHolder;
import org.python27.netty.channel.FileRegion;
import org.python27.netty.channel.MessageSizeEstimator;
import org.python27.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public DefaultMessageSizeEstimator(int unknownSize) {
        ObjectUtil.checkPositiveOrZero(unknownSize, "unknownSize");
        this.handle = new HandleImpl(unknownSize);
    }

    @Override
    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int unknownSize) {
            this.unknownSize = unknownSize;
        }

        @Override
        public int size(Object msg2) {
            if (msg2 instanceof ByteBuf) {
                return ((ByteBuf)msg2).readableBytes();
            }
            if (msg2 instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg2).content().readableBytes();
            }
            if (msg2 instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

