/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.address;

import java.net.SocketAddress;
import org.python27.netty.channel.ChannelFuture;
import org.python27.netty.channel.ChannelFutureListener;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.channel.ChannelOutboundHandlerAdapter;
import org.python27.netty.channel.ChannelPromise;

public abstract class DynamicAddressConnectHandler
extends ChannelOutboundHandlerAdapter {
    @Override
    public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        SocketAddress local;
        SocketAddress remote;
        try {
            remote = this.remoteAddress(remoteAddress, localAddress);
            local = this.localAddress(remoteAddress, localAddress);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        ctx.connect(remote, local, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) {
                if (future2.isSuccess()) {
                    future2.channel().pipeline().remove(DynamicAddressConnectHandler.this);
                }
            }
        });
    }

    protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return localAddress;
    }

    protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return remoteAddress;
    }
}

