/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.codec;

import org.python27.netty.buffer.ByteBuf;
import org.python27.netty.buffer.Unpooled;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.channel.ChannelOutboundHandlerAdapter;
import org.python27.netty.channel.ChannelPromise;
import org.python27.netty.handler.codec.EncoderException;
import org.python27.netty.util.ReferenceCountUtil;
import org.python27.netty.util.ReferenceCounted;
import org.python27.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected MessageToByteEncoder(boolean preferDirect) {
        this.matcher = TypeParameterMatcher.find(this, MessageToByteEncoder.class, "I");
        this.preferDirect = preferDirect;
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
        this.preferDirect = preferDirect;
    }

    public boolean acceptOutboundMessage(Object msg2) throws Exception {
        return this.matcher.match(msg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg2, ChannelPromise promise) throws Exception {
        block14: {
            ReferenceCounted buf = null;
            try {
                if (this.acceptOutboundMessage(msg2)) {
                    Object cast = msg2;
                    buf = this.allocateBuffer(ctx, cast, this.preferDirect);
                    try {
                        this.encode(ctx, cast, (ByteBuf)buf);
                    }
                    finally {
                        ReferenceCountUtil.release(cast);
                    }
                    if (((ByteBuf)buf).isReadable()) {
                        ctx.write(buf, promise);
                    } else {
                        buf.release();
                        ctx.write(Unpooled.EMPTY_BUFFER, promise);
                    }
                    buf = null;
                    break block14;
                }
                ctx.write(msg2, promise);
            }
            catch (EncoderException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EncoderException(e);
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, I msg2, boolean preferDirect) throws Exception {
        if (preferDirect) {
            return ctx.alloc().ioBuffer();
        }
        return ctx.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected boolean isPreferDirect() {
        return this.preferDirect;
    }
}

