/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.codec.serialization;

import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.python27.netty.buffer.ByteBuf;
import org.python27.netty.buffer.ByteBufOutputStream;
import org.python27.netty.channel.ChannelHandler;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.handler.codec.MessageToByteEncoder;
import org.python27.netty.handler.codec.serialization.CompactObjectOutputStream;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg2, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        ObjectOutputStream oout = null;
        try {
            bout.write(LENGTH_PLACEHOLDER);
            oout = new CompactObjectOutputStream(bout);
            oout.writeObject(msg2);
            oout.flush();
        }
        finally {
            if (oout != null) {
                oout.close();
            } else {
                bout.close();
            }
        }
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

