/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.python27.netty.buffer.ByteBufUtil;
import org.python27.netty.channel.ChannelHandler;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.handler.codec.MessageToMessageEncoder;
import org.python27.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset2) {
        this.charset = ObjectUtil.checkNotNull(charset2, "charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg2, List<Object> out) throws Exception {
        if (msg2.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg2), this.charset));
    }
}

