/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import org.python27.netty.channel.ChannelHandler;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import org.python27.netty.handler.ipfilter.IpFilterRule;
import org.python27.netty.handler.ipfilter.IpFilterRuleType;
import org.python27.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

