/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ssl;

import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;
import org.python27.netty.buffer.ByteBuf;
import org.python27.netty.buffer.ByteBufUtil;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.channel.ChannelOutboundHandler;
import org.python27.netty.channel.ChannelPromise;
import org.python27.netty.handler.codec.ByteToMessageDecoder;
import org.python27.netty.handler.codec.DecoderException;
import org.python27.netty.handler.ssl.NotSslRecordException;
import org.python27.netty.handler.ssl.SniCompletionEvent;
import org.python27.netty.handler.ssl.SslUtils;
import org.python27.netty.util.CharsetUtil;
import org.python27.netty.util.concurrent.Future;
import org.python27.netty.util.concurrent.FutureListener;
import org.python27.netty.util.internal.logging.InternalLogger;
import org.python27.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractSniHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractSniHandler.class);
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private ByteBuf handshakeBuffer;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            try {
                int packetLength;
                int readerIndex = in.readerIndex();
                int handshakeLength = -1;
                block7: for (int readableBytes = in.readableBytes(); readableBytes >= 5; readableBytes -= packetLength) {
                    short contentType = in.getUnsignedByte(readerIndex);
                    switch (contentType) {
                        case 20: 
                        case 21: {
                            int len = SslUtils.getEncryptedPacketLength(in, readerIndex);
                            if (len == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(in));
                                in.skipBytes(in.readableBytes());
                                ctx.fireUserEventTriggered(new SniCompletionEvent(e));
                                SslUtils.handleHandshakeFailure(ctx, e, true);
                                throw e;
                            }
                            if (len == -1) {
                                return;
                            }
                            this.select(ctx, null);
                            return;
                        }
                        case 22: {
                            short majorVersion = in.getUnsignedByte(readerIndex + 1);
                            if (majorVersion != 3) break;
                            packetLength = in.getUnsignedShort(readerIndex + 3) + 5;
                            if (readableBytes < packetLength) {
                                return;
                            }
                            if (packetLength == 5) {
                                this.select(ctx, null);
                                return;
                            }
                            int endOffset = readerIndex + packetLength;
                            if (handshakeLength == -1) {
                                if (readerIndex + 4 > endOffset) {
                                    return;
                                }
                                short handshakeType = in.getUnsignedByte(readerIndex + 5);
                                if (handshakeType != 1) {
                                    this.select(ctx, null);
                                    return;
                                }
                                handshakeLength = in.getUnsignedMedium(readerIndex + 5 + 1);
                                readerIndex += 4;
                                if (handshakeLength + 4 + 5 <= (packetLength -= 4)) {
                                    this.select(ctx, AbstractSniHandler.extractSniHostname(in, readerIndex += 5, readerIndex + handshakeLength));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = ctx.alloc().buffer(handshakeLength);
                                } else {
                                    this.handshakeBuffer.clear();
                                }
                            }
                            this.handshakeBuffer.writeBytes(in, readerIndex + 5, packetLength - 5);
                            readerIndex += packetLength;
                            if (handshakeLength > this.handshakeBuffer.readableBytes()) continue block7;
                            this.select(ctx, AbstractSniHandler.extractSniHostname(this.handshakeBuffer, 0, handshakeLength));
                            return;
                        }
                    }
                    this.select(ctx, null);
                    return;
                }
            }
            catch (NotSslRecordException e) {
                throw e;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(in), e);
                }
                this.select(ctx, null);
            }
        }
    }

    private static String extractSniHostname(ByteBuf in, int offset, int endOffset) {
        if (endOffset - (offset += 34) >= 6) {
            int extensionsLength;
            int extensionsLimit;
            short sessionIdLength = in.getUnsignedByte(offset);
            int cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
            short compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
            offset += compressionMethodLength + 1;
            if ((extensionsLimit = (offset += 2) + (extensionsLength = in.getUnsignedShort(offset))) <= endOffset) {
                while (extensionsLimit - offset >= 4) {
                    int extensionLength;
                    int extensionType = in.getUnsignedShort(offset);
                    offset += 2;
                    if (extensionsLimit - (offset += 2) < (extensionLength = in.getUnsignedShort(offset))) break;
                    if (extensionType == 0) {
                        int serverNameLength;
                        if (extensionsLimit - (offset += 2) < 3) break;
                        short serverNameType = in.getUnsignedByte(offset);
                        ++offset;
                        if (serverNameType != 0 || extensionsLimit - (offset += 2) < (serverNameLength = in.getUnsignedShort(offset))) break;
                        String hostname = in.toString(offset, serverNameLength, CharsetUtil.US_ASCII);
                        return hostname.toLowerCase(Locale.US);
                    }
                    offset += extensionLength;
                }
            }
        }
        return null;
    }

    private void releaseHandshakeBuffer() {
        if (this.handshakeBuffer != null) {
            this.handshakeBuffer.release();
            this.handshakeBuffer = null;
        }
    }

    private void select(final ChannelHandlerContext ctx, final String hostname) throws Exception {
        this.releaseHandshakeBuffer();
        Future<T> future2 = this.lookup(ctx, hostname);
        if (future2.isDone()) {
            this.fireSniCompletionEvent(ctx, hostname, future2);
            this.onLookupComplete(ctx, hostname, future2);
        } else {
            this.suppressRead = true;
            future2.addListener(new FutureListener<T>(){

                @Override
                public void operationComplete(Future<T> future2) {
                    try {
                        AbstractSniHandler.this.suppressRead = false;
                        try {
                            AbstractSniHandler.this.fireSniCompletionEvent(ctx, hostname, future2);
                            AbstractSniHandler.this.onLookupComplete(ctx, hostname, future2);
                        }
                        catch (DecoderException err) {
                            ctx.fireExceptionCaught(err);
                        }
                        catch (Exception cause) {
                            ctx.fireExceptionCaught(new DecoderException(cause));
                        }
                        catch (Throwable cause) {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                    finally {
                        if (AbstractSniHandler.this.readPending) {
                            AbstractSniHandler.this.readPending = false;
                            ctx.read();
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.releaseHandshakeBuffer();
        super.handlerRemoved0(ctx);
    }

    private void fireSniCompletionEvent(ChannelHandlerContext ctx, String hostname, Future<T> future2) {
        Throwable cause = future2.cause();
        if (cause == null) {
            ctx.fireUserEventTriggered(new SniCompletionEvent(hostname));
        } else {
            ctx.fireUserEventTriggered(new SniCompletionEvent(hostname, cause));
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3) throws Exception;

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            ctx.read();
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg2, ChannelPromise promise) throws Exception {
        ctx.write(msg2, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

