/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ssl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;
import org.python27.netty.buffer.ByteBufAllocator;
import org.python27.netty.handler.ssl.OpenSslKeyMaterial;
import org.python27.netty.handler.ssl.OpenSslKeyMaterialProvider;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final int maxCachedEntries;
    private volatile boolean full;
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager keyManager, String password, int maxCachedEntries) {
        super(keyManager, password);
        this.maxCachedEntries = maxCachedEntries;
    }

    @Override
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias2) throws Exception {
        OpenSslKeyMaterial material = (OpenSslKeyMaterial)this.cache.get(alias2);
        if (material == null) {
            material = super.chooseKeyMaterial(allocator, alias2);
            if (material == null) {
                return null;
            }
            if (this.full) {
                return material;
            }
            if (this.cache.size() > this.maxCachedEntries) {
                this.full = true;
                return material;
            }
            OpenSslKeyMaterial old = this.cache.putIfAbsent(alias2, material);
            if (old != null) {
                material.release();
                material = old;
            }
        }
        return material.retain();
    }

    @Override
    void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

