/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ssl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import org.python27.netty.buffer.ByteBufAllocator;
import org.python27.netty.buffer.UnpooledByteBufAllocator;
import org.python27.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import org.python27.netty.handler.ssl.OpenSslKeyMaterial;
import org.python27.netty.handler.ssl.OpenSslPrivateKey;
import org.python27.netty.handler.ssl.PemEncoded;
import org.python27.netty.handler.ssl.PemX509Certificate;
import org.python27.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.python27.netty.internal.tcnative.SSL;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    static void validateKeyMaterialSupported(X509Certificate[] keyCertChain, PrivateKey key, String keyPassword) throws SSLException {
        OpenSslKeyMaterialProvider.validateSupported(keyCertChain);
        OpenSslKeyMaterialProvider.validateSupported(key, keyPassword);
    }

    private static void validateSupported(PrivateKey key, String password) throws SSLException {
        if (key == null) {
            return;
        }
        long pkeyBio = 0L;
        long pkey = 0L;
        try {
            pkeyBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, key);
            pkey = SSL.parsePrivateKey((long)pkeyBio, (String)password);
        }
        catch (Exception e) {
            throw new SSLException("PrivateKey type not supported " + key.getFormat(), e);
        }
        finally {
            SSL.freeBIO((long)pkeyBio);
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
        }
    }

    private static void validateSupported(X509Certificate[] certificates) throws SSLException {
        if (certificates == null || certificates.length == 0) {
            return;
        }
        long chainBio = 0L;
        long chain2 = 0L;
        PemEncoded encoded = null;
        try {
            encoded = PemX509Certificate.toPEM(UnpooledByteBufAllocator.DEFAULT, true, certificates);
            chainBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, encoded.retain());
            chain2 = SSL.parseX509Chain((long)chainBio);
        }
        catch (Exception e) {
            throw new SSLException("Certificate type not supported", e);
        }
        finally {
            SSL.freeBIO((long)chainBio);
            if (chain2 != 0L) {
                SSL.freeX509Chain((long)chain2);
            }
            if (encoded != null) {
                encoded.release();
            }
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias2) throws Exception {
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias2);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key = this.keyManager.getPrivateKey(alias2);
        PemEncoded encoded = PemX509Certificate.toPEM(allocator, true, certificates);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain2 = 0L;
        long pkey = 0L;
        try {
            OpenSslKeyMaterial keyMaterial;
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded.retain());
            chain2 = SSL.parseX509Chain((long)chainBio);
            if (key instanceof OpenSslPrivateKey) {
                keyMaterial = ((OpenSslPrivateKey)key).newKeyMaterial(chain2, certificates);
            } else {
                pkeyBio = ReferenceCountedOpenSslContext.toBIO(allocator, key);
                pkey = key == null ? 0L : SSL.parsePrivateKey((long)pkeyBio, (String)this.password);
                keyMaterial = new DefaultOpenSslKeyMaterial(chain2, pkey, certificates);
            }
            chain2 = 0L;
            pkey = 0L;
            OpenSslKeyMaterial openSslKeyMaterial = keyMaterial;
            return openSslKeyMaterial;
        }
        finally {
            SSL.freeBIO((long)chainBio);
            SSL.freeBIO((long)pkeyBio);
            if (chain2 != 0L) {
                SSL.freeX509Chain((long)chain2);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
            encoded.release();
        }
    }

    void destroy() {
    }
}

