/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ssl;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.python27.netty.util.internal.EmptyArrays;

final class PseudoRandomFunction {
    private PseudoRandomFunction() {
    }

    static byte[] hash(byte[] secret, byte[] label, byte[] seed, int length, String algo) {
        if (length < 0) {
            throw new IllegalArgumentException("You must provide a length greater than zero.");
        }
        try {
            byte[] data;
            Mac hmac2 = Mac.getInstance(algo);
            hmac2.init(new SecretKeySpec(secret, algo));
            int iterations = (int)Math.ceil((double)length / (double)hmac2.getMacLength());
            byte[] expansion = EmptyArrays.EMPTY_BYTES;
            byte[] A = data = PseudoRandomFunction.concat(label, seed);
            for (int i = 0; i < iterations; ++i) {
                A = hmac2.doFinal(A);
                expansion = PseudoRandomFunction.concat(expansion, hmac2.doFinal(PseudoRandomFunction.concat(A, data)));
            }
            return Arrays.copyOf(expansion, length);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Could not find algo: " + algo, e);
        }
    }

    private static byte[] concat(byte[] first, byte[] second) {
        byte[] result2 = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result2, first.length, second.length);
        return result2;
    }
}

