/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.handler.ssl.ocsp;

import javax.net.ssl.SSLHandshakeException;
import org.python27.netty.channel.ChannelHandlerContext;
import org.python27.netty.channel.ChannelInboundHandlerAdapter;
import org.python27.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.python27.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.python27.netty.util.internal.ObjectUtil;

public abstract class OcspClientHandler
extends ChannelInboundHandlerAdapter {
    private final ReferenceCountedOpenSslEngine engine;

    protected OcspClientHandler(ReferenceCountedOpenSslEngine engine) {
        this.engine = ObjectUtil.checkNotNull(engine, "engine");
    }

    protected abstract boolean verify(ChannelHandlerContext var1, ReferenceCountedOpenSslEngine var2) throws Exception;

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            ctx.pipeline().remove(this);
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess() && !this.verify(ctx, this.engine)) {
                throw new SSLHandshakeException("Bad OCSP response");
            }
        }
        ctx.fireUserEventTriggered(evt);
    }
}

