/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Map;
import org.python27.netty.util.internal.InternalThreadLocalMap;
import org.python27.netty.util.internal.ObjectUtil;

public final class CharsetUtil {
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Charset[] CHARSETS = new Charset[]{UTF_16, UTF_16BE, UTF_16LE, UTF_8, ISO_8859_1, US_ASCII};

    public static Charset[] values() {
        return CHARSETS;
    }

    @Deprecated
    public static CharsetEncoder getEncoder(Charset charset2) {
        return CharsetUtil.encoder(charset2);
    }

    public static CharsetEncoder encoder(Charset charset2, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        ObjectUtil.checkNotNull(charset2, "charset");
        CharsetEncoder e = charset2.newEncoder();
        e.onMalformedInput(malformedInputAction).onUnmappableCharacter(unmappableCharacterAction);
        return e;
    }

    public static CharsetEncoder encoder(Charset charset2, CodingErrorAction codingErrorAction) {
        return CharsetUtil.encoder(charset2, codingErrorAction, codingErrorAction);
    }

    public static CharsetEncoder encoder(Charset charset2) {
        ObjectUtil.checkNotNull(charset2, "charset");
        Map<Charset, CharsetEncoder> map = InternalThreadLocalMap.get().charsetEncoderCache();
        CharsetEncoder e = map.get(charset2);
        if (e != null) {
            e.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return e;
        }
        e = CharsetUtil.encoder(charset2, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        map.put(charset2, e);
        return e;
    }

    @Deprecated
    public static CharsetDecoder getDecoder(Charset charset2) {
        return CharsetUtil.decoder(charset2);
    }

    public static CharsetDecoder decoder(Charset charset2, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        ObjectUtil.checkNotNull(charset2, "charset");
        CharsetDecoder d = charset2.newDecoder();
        d.onMalformedInput(malformedInputAction).onUnmappableCharacter(unmappableCharacterAction);
        return d;
    }

    public static CharsetDecoder decoder(Charset charset2, CodingErrorAction codingErrorAction) {
        return CharsetUtil.decoder(charset2, codingErrorAction, codingErrorAction);
    }

    public static CharsetDecoder decoder(Charset charset2) {
        ObjectUtil.checkNotNull(charset2, "charset");
        Map<Charset, CharsetDecoder> map = InternalThreadLocalMap.get().charsetDecoderCache();
        CharsetDecoder d = map.get(charset2);
        if (d != null) {
            d.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return d;
        }
        d = CharsetUtil.decoder(charset2, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        map.put(charset2, d);
        return d;
    }

    private CharsetUtil() {
    }
}

