/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.util;

import org.python27.netty.util.ReferenceCounted;
import org.python27.netty.util.ResourceLeakDetector;
import org.python27.netty.util.ThreadDeathWatcher;
import org.python27.netty.util.internal.StringUtil;
import org.python27.netty.util.internal.logging.InternalLogger;
import org.python27.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T msg2) {
        if (msg2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg2).retain();
        }
        return msg2;
    }

    public static <T> T retain(T msg2, int increment) {
        if (msg2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg2).retain(increment);
        }
        return msg2;
    }

    public static <T> T touch(T msg2) {
        if (msg2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg2).touch();
        }
        return msg2;
    }

    public static <T> T touch(T msg2, Object hint) {
        if (msg2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg2).touch(hint);
        }
        return msg2;
    }

    public static boolean release(Object msg2) {
        if (msg2 instanceof ReferenceCounted) {
            return ((ReferenceCounted)msg2).release();
        }
        return false;
    }

    public static boolean release(Object msg2, int decrement) {
        if (msg2 instanceof ReferenceCounted) {
            return ((ReferenceCounted)msg2).release(decrement);
        }
        return false;
    }

    public static void safeRelease(Object msg2) {
        try {
            ReferenceCountUtil.release(msg2);
        }
        catch (Throwable t) {
            logger.warn("Failed to release a message: {}", msg2, (Object)t);
        }
    }

    public static void safeRelease(Object msg2, int decrement) {
        block2: {
            try {
                ReferenceCountUtil.release(msg2, decrement);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to release a message: {} (decrement: {})", msg2, decrement, t);
            }
        }
    }

    @Deprecated
    public static <T> T releaseLater(T msg2) {
        return ReferenceCountUtil.releaseLater(msg2, 1);
    }

    @Deprecated
    public static <T> T releaseLater(T msg2, int decrement) {
        if (msg2 instanceof ReferenceCounted) {
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReleasingTask((ReferenceCounted)msg2, decrement));
        }
        return msg2;
    }

    public static int refCnt(Object msg2) {
        return msg2 instanceof ReferenceCounted ? ((ReferenceCounted)msg2).refCnt() : -1;
    }

    private ReferenceCountUtil() {
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }

    private static final class ReleasingTask
    implements Runnable {
        private final ReferenceCounted obj;
        private final int decrement;

        ReleasingTask(ReferenceCounted obj, int decrement) {
            this.obj = obj;
            this.decrement = decrement;
        }

        @Override
        public void run() {
            try {
                if (!this.obj.release(this.decrement)) {
                    logger.warn("Non-zero refCnt: {}", (Object)this);
                } else {
                    logger.debug("Released: {}", (Object)this);
                }
            }
            catch (Exception ex) {
                logger.warn("Failed to release an object: {}", (Object)this.obj, (Object)ex);
            }
        }

        public String toString() {
            return StringUtil.simpleClassName(this.obj) + ".release(" + this.decrement + ") refCnt: " + this.obj.refCnt();
        }
    }
}

