/*
 * Decompiled with CFR 0.152.
 */
package org.python27.netty.util.concurrent;

import org.python27.netty.util.concurrent.EventExecutor;
import org.python27.netty.util.concurrent.Future;
import org.python27.netty.util.concurrent.GenericFutureListener;
import org.python27.netty.util.concurrent.ImmediateEventExecutor;
import org.python27.netty.util.concurrent.Promise;
import org.python27.netty.util.internal.ObjectUtil;

public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final GenericFutureListener<Future<?>> listener = new GenericFutureListener<Future<?>>(){

        @Override
        public void operationComplete(final Future<?> future2) {
            if (PromiseCombiner.this.executor.inEventLoop()) {
                this.operationComplete0(future2);
            } else {
                PromiseCombiner.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        this.operationComplete0(future2);
                    }
                });
            }
        }

        private void operationComplete0(Future<?> future2) {
            assert (PromiseCombiner.this.executor.inEventLoop());
            ++PromiseCombiner.this.doneCount;
            if (!future2.isSuccess() && PromiseCombiner.this.cause == null) {
                PromiseCombiner.this.cause = future2.cause();
            }
            if (PromiseCombiner.this.doneCount == PromiseCombiner.this.expectedCount && PromiseCombiner.this.aggregatePromise != null) {
                PromiseCombiner.this.tryPromise();
            }
        }
    };
    private final EventExecutor executor;

    @Deprecated
    public PromiseCombiner() {
        this(ImmediateEventExecutor.INSTANCE);
    }

    public PromiseCombiner(EventExecutor executor) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
    }

    @Deprecated
    public void add(Promise promise) {
        this.add((Future)promise);
    }

    public void add(Future future2) {
        this.checkAddAllowed();
        this.checkInEventLoop();
        ++this.expectedCount;
        future2.addListener(this.listener);
    }

    @Deprecated
    public void addAll(Promise ... promises) {
        this.addAll((Future[])promises);
    }

    public void addAll(Future ... futures) {
        for (Future future2 : futures) {
            this.add(future2);
        }
    }

    public void finish(Promise<Void> aggregatePromise) {
        ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        this.checkInEventLoop();
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Already finished");
        }
        this.aggregatePromise = aggregatePromise;
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private void checkInEventLoop() {
        if (!this.executor.inEventLoop()) {
            throw new IllegalStateException("Must be called from EventExecutor thread");
        }
    }

    private boolean tryPromise() {
        return this.cause == null ? this.aggregatePromise.trySuccess(null) : this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }
}

