/*
 * Decompiled with CFR 0.152.
 */
package org.python27.sizeof;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.python27.sizeof.RamUsageEstimator;
import sun.misc.Unsafe;

public final class BlackMagic {
    public static Unsafe getUnsafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsafe not available.", t);
        }
    }

    public static String objectMemoryAsString(Object o) {
        Unsafe unsafe = BlackMagic.getUnsafe();
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        StringBuilder b = new StringBuilder();
        int obSize = (int)RamUsageEstimator.shallowSizeOf(o);
        for (int i = 0; i < obSize; i += 2) {
            if ((i & 0xF) == 0) {
                if (i > 0) {
                    b.append("\n");
                }
                b.append(String.format(Locale.ENGLISH, "%#06x", i));
            }
            short shortValue = unsafe.getShort(o, i);
            if (byteOrder == ByteOrder.BIG_ENDIAN) {
                b.append(String.format(Locale.ENGLISH, " %02x", shortValue >>> 8 & 0xFF));
                b.append(String.format(Locale.ENGLISH, " %02x", shortValue & 0xFF));
                continue;
            }
            b.append(String.format(Locale.ENGLISH, " %02x", shortValue & 0xFF));
            b.append(String.format(Locale.ENGLISH, " %02x", shortValue >>> 8 & 0xFF));
        }
        return b.toString();
    }

    public static String fieldsLayoutAsString(Class<?> clazz) {
        Unsafe unsafe = BlackMagic.getUnsafe();
        TreeMap<Long, String> fields = new TreeMap<Long, String>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                fields.put(unsafe.objectFieldOffset(f), f.getDeclaringClass().getSimpleName() + "." + f.getName());
            }
        }
        fields.put(RamUsageEstimator.shallowSizeOfInstance(clazz), "#shallowSizeOfInstance(" + clazz.getName() + ")");
        StringBuilder b = new StringBuilder();
        Object[] entries = fields.entrySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry e = (Map.Entry)entries[i];
            Map.Entry next = i + 1 < entries.length ? (Map.Entry)entries[i + 1] : null;
            b.append(String.format(Locale.ENGLISH, "@%02d %2s %s\n", e.getKey(), next == null ? "" : Long.valueOf((Long)next.getKey() - (Long)e.getKey()), e.getValue()));
        }
        return b.toString();
    }
}

