/*
 * Decompiled with CFR 0.152.
 */
package org.python27.util;

import org.python27.core.CompileMode;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyObject;
import org.python27.core.PySystemState;
import org.python27.core.ThreadState;
import org.python27.core.TraceFunction;
import org.python27.util.BreakTraceFunction;
import org.python27.util.PythonInterpreter;

public class InteractiveInterpreter
extends PythonInterpreter {
    public StringBuilder buffer = new StringBuilder();
    public String filename = "<stdin>";

    public InteractiveInterpreter() {
        this(null);
    }

    public InteractiveInterpreter(PyObject locals) {
        this(locals, null);
    }

    public InteractiveInterpreter(PyObject locals, PySystemState systemState) {
        super(locals, systemState);
    }

    public boolean runsource(String source) {
        return this.runsource(source, "<input>", CompileMode.single);
    }

    public boolean runsource(String source, String filename) {
        return this.runsource(source, filename, CompileMode.single);
    }

    public boolean runsource(String source, String filename, CompileMode kind) {
        PyObject code2;
        try {
            code2 = Py.compile_command_flags(source, filename, kind, this.cflags, true);
        }
        catch (PyException exc) {
            if (exc.match(Py.SyntaxError)) {
                this.showexception(exc);
                return false;
            }
            if (exc.match(Py.ValueError) || exc.match(Py.OverflowError)) {
                this.showexception(exc);
                return false;
            }
            throw exc;
        }
        if (code2 == Py.None) {
            return true;
        }
        this.runcode(code2);
        return false;
    }

    public void runcode(PyObject code2) {
        try {
            this.exec(code2);
        }
        catch (PyException exc) {
            if (exc.match(Py.SystemExit)) {
                throw exc;
            }
            this.showexception(exc);
        }
    }

    public void showexception(PyException exc) {
        Py.printException(exc);
    }

    public void write(String data) {
        Py.stderr.write(data);
    }

    public void resetbuffer() {
        this.buffer.setLength(0);
    }

    public void interrupt(ThreadState ts) {
        BreakTraceFunction breaker = new BreakTraceFunction();
        TraceFunction oldTrace = ts.tracefunc;
        ts.tracefunc = breaker;
        if (ts.frame != null) {
            ts.frame.tracefunc = breaker;
        }
        ts.tracefunc = oldTrace;
    }
}

