/*
 * Decompiled with CFR 0.152.
 */
package org.python27.util;

class OptionScanner {
    private final String programOpts;
    private int argIndex = 0;
    private int optIndex = 0;
    private String optarg = null;
    private String message = "";
    private String[] args;
    static final char DONE = '\uffff';
    static final char ERROR = '\ufffe';
    static final char ARGUMENT = '\ufffd';
    private final LongSpec[] longSpec;

    OptionScanner(String[] args, String programOpts, LongSpec[] longSpec) {
        this.args = args;
        this.programOpts = programOpts;
        this.longSpec = longSpec;
    }

    char getOption() {
        int ptr;
        this.message = "";
        this.optarg = null;
        if (this.argIndex >= this.args.length) {
            return '\uffff';
        }
        String arg = this.args[this.argIndex];
        if (this.optIndex == 0) {
            if (!arg.startsWith("-") || arg.length() <= 1) {
                return '\ufffd';
            }
            if (this.longSpec != null) {
                for (LongSpec spec : this.longSpec) {
                    if (!spec.key.equals(arg)) continue;
                    if (spec.hasArgument) {
                        if (++this.argIndex < this.args.length) {
                            this.optarg = this.args[this.argIndex];
                        } else {
                            return this.error("Argument expected for the %s option", arg);
                        }
                    }
                    ++this.argIndex;
                    return spec.returnValue;
                }
            }
            this.optIndex = 1;
        }
        assert (this.argIndex < this.args.length);
        assert (this.optIndex > 0);
        assert (this.optIndex < arg.length());
        char option = arg.charAt(this.optIndex++);
        if (this.optIndex >= arg.length()) {
            ++this.argIndex;
            this.optIndex = 0;
        }
        if ((ptr = this.programOpts.indexOf(option)) < 0 || option == ':') {
            if (arg.length() <= 2) {
                return this.error("Unknown option: -%c", Character.valueOf(option));
            }
            return this.error("Unknown option: -%c or '%s'", Character.valueOf(option), arg);
        }
        if (++ptr < this.programOpts.length() && this.programOpts.charAt(ptr) == ':') {
            if (this.argIndex < this.args.length) {
                this.optarg = this.args[this.argIndex].substring(this.optIndex);
                ++this.argIndex;
                this.optIndex = 0;
            } else {
                return this.error("Argument expected for the -%c option", Character.valueOf(option));
            }
        }
        return option;
    }

    String getOptionArgument() {
        return this.optarg;
    }

    String getWholeArgument() {
        this.optIndex = 0;
        return this.args[this.argIndex++];
    }

    String peekWholeArgument() {
        return this.args[this.argIndex];
    }

    int countRemainingArguments() {
        return this.args.length - this.argIndex;
    }

    String getMessage() {
        return this.message;
    }

    char error(String message2, Object ... args) {
        this.message = String.format(message2, args);
        return '\ufffe';
    }

    static class LongSpec {
        final String key;
        final char returnValue;
        final boolean hasArgument;

        public LongSpec(String key, char returnValue, boolean hasArgument) {
            this.key = key;
            this.returnValue = returnValue;
            this.hasArgument = hasArgument;
        }

        public LongSpec(String key, char returnValue) {
            this(key, returnValue, false);
        }
    }
}

